/* 
 * Copyright (C) 2003  Sam Vaughan <yamaneko@centurytel.net>
 *
 * File: cod.c
 * This file is part of Vrcon
 *
 * Vrcon
 * VaughanTech's  remote control for Cstrike and other Half-Life MODS
 * (rcon from a terminal)
 * 
 * Written by Sam "Jack Bauer" Vaughan
 *
 *
 * Licensed under the GNU General Public License
 *
 * Vrcon is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * Vrcon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Vrcon; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
*/

#include "sv.h"
#include "quake3.h"
#include "config.h"


extern char *adminWONIDS[MAX_ADMINS];
extern int  TOTAL_ADMINS;

extern char *flagWONIDS[MAX_ADMINS];
extern int  TOTAL_FLAG;

extern char *flagIP[MAX_ADMINS];
extern int  TOTAL_IP;

extern q3_player q3p[];
extern int cur_q3p;

q3_server_info q3si;

char *cod_menu[] = 
{
	"sRefresh",
	"arcon",
	"mMap",
	"MRestart",
	"KKick",
	"iServer",
#ifdef PUNKBUSTER
	"ppb_pblist",
	"Ppb_ss",
#endif 
	"qQuit",
	0,
};


/* return gametupe for rcon use 
*/

char *  cod_gametype_box(void)
{

	int i =0;
	int j;
	int key = 0;
	int max_rows = 16;
	int max_item = 0;
	int top_view_row = 0;
	int sel_index = 0;
	char *spc;
	static char ret_gtype[30];

	static char gametype[7][30] = 
	{

		"dm  Death Match",
		"bel Behind Enemy Lines",
		"re  Retrieval",
		"sd  Search Destroy",
		"hq  Head Quarters",
		"tdm Team Death Match",
		{0},

	}; 

	WINDOW *mbox;

	mbox = newwin(max_rows +2,30,3,9);
	box(mbox,'|','-');
	keypad(mbox,TRUE);
	cbreak();
	noecho();


	// set max entries
	max_item = 5;
	
	mvwprintw(mbox,0,2, " [ Select Gametype ] ");
	// only draw the up to the max_rows
	for(i=0;i<(max_rows );i++) {
		if(i == sel_index) {
			wattron(mbox,A_REVERSE);
		}
		else {
			wattroff(mbox,A_REVERSE);
		}

		if(i <= max_item)
			mvwprintw(mbox,i+1,1, " %s", gametype[i] );
	}

	wattroff(mbox,A_REVERSE);
	wrefresh(mbox);

	key = 0;
	while(key != 'q' && key != KEY_ENTER && key != '\n') {

		key = getch();

		if(key == 65) { //UP
			if(sel_index == top_view_row) {
				if(sel_index == 0) {
					sel_index = 0;
				} 
				else {
					top_view_row--;
					sel_index--;
				}
			}	
			else
				sel_index--; 
		}
		if(key == 66) { //DOWN
			if(sel_index == (top_view_row + max_rows -1 )) {
				if(sel_index == max_item)
					sel_index = sel_index;
				else {
					top_view_row++;
					sel_index++;
				}
			}	
			else {
				if(sel_index != max_item) 
					sel_index++;
			}
		}

		if((key == 32) || (key == 110)) { // n or SPACE BAR - (PAGE DOWN)

			if((top_view_row + max_rows) > (max_item - (max_rows -1)) ) {
				if (max_item <= max_rows ) {
					top_view_row = 0;
					sel_index = max_item;
				}
				else {
					top_view_row = (max_item - (max_rows -1));
					sel_index = top_view_row;
				}
			}	
			else {
				top_view_row = (top_view_row + max_rows);
				sel_index = top_view_row;
			}
		}

		if(key == 112) { //p - (Previous - PAGE up)

			if((top_view_row - max_rows ) < 0) {
				top_view_row = 0;
				sel_index = top_view_row;
			}	
			else {
				top_view_row = (top_view_row - max_rows);
				sel_index = top_view_row;
			}
		}

		if(key == 116) { //t - TOP  jump to the top of the list

			top_view_row = 0;
			sel_index = top_view_row;
		}

		if(key == 98) { //b - BOTTOM  jump to the BOTTOM of the list

			if (max_item <= max_rows ) {
				top_view_row = 0;
				sel_index = max_item;
			}
			else {
				top_view_row = (max_item - (max_rows -1));
				sel_index = top_view_row;
			}


		}

		j = top_view_row;;
		for(i=0;i<max_rows ;i++,j++) {
			if(j == sel_index) {
				wattron(mbox,A_REVERSE);
			}
			else {
				wattroff(mbox,A_REVERSE);
			}

			if(i <= max_item) {
				mvwprintw(mbox,i+1,1, "                            ");
				mvwprintw(mbox,i+1,1, " %s", gametype[j]);
			}
		}

		wattroff(mbox,A_REVERSE);
		wrefresh(mbox);
	}

	if(key == 'q') 
		return NULL;

	keypad(mbox, FALSE);
	nocbreak();
	echo();

	memset(ret_gtype, '\0', sizeof(ret_gtype));
	strlcpy(ret_gtype, gametype[sel_index], sizeof(ret_gtype));
	spc = strchr(ret_gtype,' ');
	*spc = '\0';

	return(ret_gtype);

}



char *  cod_mbox(char *g)
{

	int ii;
	int xx;
	int i =0;
	int j;
	int key = 0;
	int max_rows = 16;
	int max_item = 0;
	int top_view_row = 0;
	int sel_index = 0;
	char *mapbuf = NULL;
	char *dot;
	char gtype[15];
	static char maps[MAX_MAPS][MAX_MAP_NAME];
	char buf[MAX_RETBUF +1];
	char tbuf[250];

	WINDOW *mbox;


	for(i=0;i<MAX_MAPS;i++) {
		memset(maps[i], '\0', MAX_MAP_NAME) ;
	}

	memset(gtype,'\0',sizeof(gtype));
	mbox = newwin(max_rows +2,30,3,15);
	box(mbox,'|','-');
	keypad(mbox,TRUE);
	cbreak();
	noecho();

	mvwprintw(mbox,0,2, " [ Select Map      ] ");

	if (strstr(serv[cur_serv].game,"cod")) {
		//mapbuf = send_moh_rcon("sv_mapRotation");
		//mapbuf = send_q3_rcon("sv_mapRotation");
		mapbuf = send_q3_rcon("fdir maps/mp*bsp");
		if(mapbuf == NULL)
			return NULL ;

		i=0;
		memset(buf,'\0',sizeof(buf));
		memset(tbuf,'\0',sizeof(tbuf));
		strlcpy(buf,mapbuf,sizeof(buf));

		for(ii=0,xx=0;ii<strlen(buf);ii++,xx++) {
			if(buf[ii] == '\n') {

				if(strstr(tbuf,".bsp")) {
					if((dot = strchr(tbuf,'.')))
						*dot = '\0';

					dot = strrchr(tbuf,'/');
					strlcpy(maps[i++],dot+1 , sizeof(maps[i]));
				}
				
				memset(tbuf,'\0',sizeof(tbuf));
				xx=-1;
			}
			else
				tbuf[xx] = buf[ii];
		}
	}
	else {
		mapbuf = NULL;
	}

	if(mapbuf == NULL) {
		return NULL;
	}

	// get max entries
	for(i=0;i<MAX_MAPS;i++) {
		if(maps[i][0] != '\0')
			max_item++;	
	}
	max_item--;
	
	// only draw the up to the max_rows
	for(i=0;i<(max_rows );i++) {
		if(i == sel_index) {
			wattron(mbox,A_REVERSE);
		}
		else {
			wattroff(mbox,A_REVERSE);
		}

		mvwprintw(mbox,i+1,1, " %s", maps[i]);
	}

	wattroff(mbox,A_REVERSE);
	wrefresh(mbox);

	key = 0;
	while(key != 'q' && key != KEY_ENTER && key != '\n') {

		key = getch();

		if(key == 65) { //UP
			if(sel_index == top_view_row) {
				if(sel_index == 0) {
					sel_index = 0;
				} 
				else {
					top_view_row--;
					sel_index--;
				}
			}	
			else
				sel_index--; 
		}
		if(key == 66) { //DOWN
			if(sel_index == (top_view_row + max_rows -1 )) {
				if(sel_index == max_item)
					sel_index = sel_index;
				else {
					top_view_row++;
					sel_index++;
				}
			}	
			else {
				if(sel_index != max_item) 
					sel_index++;
			}
		}

		if((key == 32) || (key == 110)) { // n or SPACE BAR - (PAGE DOWN)

			if((top_view_row + max_rows) > (max_item - (max_rows -1)) ) {
				top_view_row = (max_item - (max_rows -1));
				sel_index = top_view_row;
			}	
			else {
				top_view_row = (top_view_row + max_rows);
				sel_index = top_view_row;
			}
		}

		if(key == 112) { //p - (Previous - PAGE up)

			if((top_view_row - max_rows ) < 0) {
				top_view_row = 0;
				sel_index = top_view_row;
			}	
			else {
				top_view_row = (top_view_row - max_rows);
				sel_index = top_view_row;
			}
		}

		if(key == 116) { //t - TOP  jump to the top of the list

			top_view_row = 0;
			sel_index = top_view_row;
		}

		if(key == 98) { //b - BOTTOM  jump to the BOTTOM of the list
			top_view_row = (max_item - (max_rows -1));
			sel_index = top_view_row;
		}

		j = top_view_row;;
		for(i=0;i<max_rows ;i++,j++) {
			if(j == sel_index) {
				wattron(mbox,A_REVERSE);
			}
			else {
				wattroff(mbox,A_REVERSE);
			}

			mvwprintw(mbox,i+1,1, "                            ");
			mvwprintw(mbox,i+1,1, " %s", maps[j]);
		}

		wattroff(mbox,A_REVERSE);
		wrefresh(mbox);
	}

	if(key == 'q') 
		return NULL;

	keypad(mbox, FALSE);
	nocbreak();
	echo();
	clear();
	delwin(mbox);
	wrefresh(stdscr);
	return(maps[sel_index]);

}

