/* 
 * Copyright (C) 2003  Sam Vaughan <yamaneko@centurytel.net>
 *
 * File: load_config.c
 * This file is part of Vrcon
 *
 * Vrcon
 * VaughanTech's  remote control for Cstrike and other Half-Life MODS
 * (rcon from a terminal)
 * 
 * Written by Sam "Jack Bauer" Vaughan
 *
 *
 * Licensed under the GNU General Public License
 *
 * Vrcon is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * Vrcon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Vrcon; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
*/

#include "sv.h"
#include "config.h"

char *adminWONIDS[MAX_ADMINS];
int  TOTAL_ADMINS;

char *flagWONIDS[MAX_ADMINS];
int  TOTAL_FLAG;

char *flagIP[MAX_ADMINS];
int  TOTAL_IP;

extern char config_path[MAX_STRING];


int load_config()
{
	int i = 0;
	char c; 
	char lbuf[256];
	char adminbuf[1024];
	char *lb[20];
	char Delim_comma = ',';
	char *h;

	char line[256];
	char tag[64];
	char avalue[192];
	char cursect[256];
	char *c2;

	int nr;
	int servernum;
	bool sect;

	extern long r_timeout_sec;
	extern long r_timeout_usec;
	
	extern char cmsay_color[5]; 
	extern char amxsay_color[15]; 

	FILE *f;   
	FILE *tf;  
	FILE *tfw; 

	i = 0;
	memset(lbuf,'\0', sizeof(lbuf));
	memset(adminbuf,'\0', sizeof(lbuf));

	for (i= 0 ; i < 20 ; i++) {
		lb[i] = (char *) malloc(50);
		if (lb[i] == NULL) {
			printf("Memory allocation failed\n");
		}
		else {
			memset(lb[i],'\0',50);
		}
	}

	for (i= 0 ; i < MAX_ADMINS ; i++) {
		adminWONIDS[i] = (char *) malloc(MAX_WONID_LEN);
		if (adminWONIDS[i] == NULL) {
			printf("Memory allocation failed\n");
		}
		else {
			memset(adminWONIDS[i],'\0',MAX_WONID_LEN);
		}
	}

	for (i= 0 ; i < MAX_ADMINS ; i++) {
		flagWONIDS[i] = (char *) malloc(MAX_WONID_LEN);
		if (flagWONIDS[i] == NULL) {
			printf("Memory allocation failed\n");
		}
		else {
			memset(flagWONIDS[i],'\0',MAX_WONID_LEN);
		}
	}

	for (i= 0 ; i < MAX_ADMINS ; i++) {
		flagIP[i] = (char *) malloc(MAX_IP_LEN);
		if (flagIP[i] == NULL) {
			printf("Memory allocation failed\n");
		}
		else {
			memset(flagIP[i],'\0',MAX_IP_LEN);
		}
	}


	if(config_path[0] == '\0') {

		h = getenv("HOME");
		snprintf(config_path, sizeof(config_path),"%s/.vrcon",h);
		if((f = fopen(config_path,"r")) == NULL) {

			/* Its a new install or .vrcon isn't there 
			   Try to copy the sample one from the share dir
			*/
			
			if((tf = fopen("/usr/local/share/vrcon/vrcon_sample_config","r")) == NULL) {
				printf("error: No vrcon_sample_config file!  \n");
				exit(0);
			}
			else {
				if((tfw = fopen(config_path,"w")) == NULL) {
					printf("error creating %s\n",config_path);
					exit(0);
				}
				
				 /* Copy over sample 
				 */
				 while((c = fgetc(tf)) != EOF)
				{ 
					fputc(c,tfw);
				}       
		
				fclose(tf);
				fclose(tfw);
				load_config();
				return(0);
			}
		}

	}
	else {
		if((f = fopen(config_path,"r")) == NULL) {
			printf("Unable to open %s\n", config_path);
			exit(0);
		}
	}

	i = 0;	
	sect = false;
	servernum = -1;
	nr = 0;

	while (NULL != fgets(line,255,f)) {

		nr++;
		if (line[0] == '\n' || line[0] == '#' || line[0] == ';')
			continue;
		if (1 == sscanf(line,"[%99[^]]]",avalue)) {
		    /* [section] */
			sect = true;	
			memset(cursect,'\0',sizeof(cursect));
			strcat(cursect,avalue);
			if((strcmp(cursect,"hlife") == 0) || 
		          (strcmp(cursect,"moh") ==0 ) || 
		          (strcmp(cursect,"source") ==0 ) || 
		          (strcmp(cursect,"bf1942") ==0 ) || 
		          (strcmp(cursect,"ut2k4") ==0 ) || 
		          (strcmp(cursect,"quake3") ==0 ) || 
			  (strcmp(cursect,"cod") ==0 )) {
				servernum++;
				if(servernum > MAX_SERV)
					servernum = MAX_SERV;
				serv[servernum].set = true;
			}

		} 
		else if (2 == sscanf(line," %63[^= ] = %191[^\n]",tag,avalue)) {

			if (false == sect) {
				fprintf(stderr,"%d: value outside of a section ... Ignoring\n",nr);
			} 
			else {
				c2 = avalue + strlen(avalue)-1;
				while (c2 > avalue  &&  (*c2 == ' ' || *c2 == '\t'))
				    *(c2--) = 0;
		


				if(strcmp(cursect, "global") == 0 ) {
					
					if(strcmp(tag, "timeout") == 0) {
						r_timeout_sec = atoi(avalue);
					}

					if(strcmp(tag, "u_timeout") == 0) {
						r_timeout_usec = atoi(avalue);
					}

					if(strcmp(tag, "admins") == 0) {
						strlcpy(adminbuf, avalue,sizeof(adminbuf));
						TOTAL_ADMINS = split( adminbuf, adminWONIDS,Delim_comma,MAX_ADMINS, MAX_WONID_LEN );
					}

					if(strcmp(tag, "flag") == 0) {
						strlcpy(adminbuf, avalue,sizeof(adminbuf));

						TOTAL_FLAG = split( adminbuf, flagWONIDS,Delim_comma,MAX_ADMINS, MAX_WONID_LEN );
					}

					if(strcmp(tag, "flagip") == 0) {
						strlcpy(adminbuf, avalue,sizeof(adminbuf));

						TOTAL_IP = split( adminbuf, flagIP,Delim_comma,MAX_ADMINS, MAX_IP_LEN );
					}

					if(strcmp(tag, "cmsay_color") == 0)
						strlcpy(cmsay_color, avalue, sizeof(cmsay_color));

					if(strcmp(tag, "amxsay_color") == 0)
						strlcpy(amxsay_color, avalue, sizeof(amxsay_color));

				}
				else if(strcmp(cursect, "vlog") == 0 ) {
					if(strcmp(tag, "cs_tcolor") == 0)
						strlcpy(vlogcolor.cs_tcolor, avalue, sizeof(vlogcolor.cs_tcolor));
					if(strcmp(tag, "cs_ctcolor") == 0)
						strlcpy(vlogcolor.cs_ctcolor, avalue, sizeof(vlogcolor.cs_ctcolor));
					if(strcmp(tag, "cs_rcon") == 0)
						strlcpy(vlogcolor.cs_rcon, avalue, sizeof(vlogcolor.cs_rcon));
					if(strcmp(tag, "cs_bankick") == 0)
						strlcpy(vlogcolor.cs_bankick, avalue, sizeof(vlogcolor.cs_bankick));
					if(strcmp(tag, "cs_say") == 0)
						strlcpy(vlogcolor.cs_say, avalue, sizeof(vlogcolor.cs_say));

				}
				else if((strcmp(cursect, "hlife") == 0 ) || 
					(strcmp(cursect, "quake3") == 0 ) || 
					(strcmp(cursect, "bf1942") == 0 ) || 
					(strcmp(cursect, "ut2k4") == 0 ) || 
					(strcmp(cursect, "moh") == 0 )  || 
					(strcmp(cursect, "doom3") == 0 )  || 
					(strcmp(cursect, "source") == 0 )  || 
					(strcmp(cursect, "cod") == 0 ) ) {

					if(strcmp(tag, "name") == 0) {
						strlcpy(serv[servernum].name, avalue, sizeof(serv[servernum].name));
						strlcpy(serv[servernum].game, cursect, sizeof(serv[servernum].game));
					}

					if(strcmp(tag, "ip") == 0)
						strlcpy(serv[servernum].cs_server_addr, avalue, sizeof(serv[servernum].cs_server_addr));
			
					if(strcmp(tag, "sport") == 0) 
						serv[servernum].cs_server_port = atoi(avalue);

					if(strcmp(tag, "rport") == 0) 
						serv[servernum].rcon_port = atoi(avalue);

					if(strcmp(tag, "password") == 0) 
						strlcpy(serv[servernum].rcon_password, avalue, sizeof(serv[servernum].rcon_password));

					if(strcmp(tag, "username") == 0) 
						strlcpy(serv[servernum].rcon_uname, avalue, sizeof(serv[servernum].rcon_uname));

				}


			}
		} 
		else {
		    fprintf(stderr,"%d: syntax error\n",nr);
		}
	}

	fclose(f);
	return(0);
}

