
/* 
 * Copyright (C) 2003  Sam Vaughan <yamaneko@centurytel.net>
 *
 * File: moh.c
 * This file is part of Vrcon
 *
 * Vrcon
 * VaughanTech's  remote control for Cstrike and other Half-Life MODS
 * (rcon from a terminal)
 * 
 * Written by Sam "Jack Bauer" Vaughan
 *
 *
 * Licensed under the GNU General Public License
 *
 * Vrcon is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * Vrcon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Vrcon; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
*/

#include "sv.h"
#include "rcon.h"
#include "moh.h"
#include "bf1942.h"  // We can use the already existing data structures.
#include "config.h"


extern char *adminWONIDS[MAX_ADMINS];
extern int  TOTAL_ADMINS;

extern char *flagWONIDS[MAX_ADMINS];
extern int  TOTAL_FLAG;

extern char *flagIP[MAX_ADMINS];
extern int  TOTAL_IP;

extern ea_server_info bfsi;

char *moh_menu[] = 
{
	"sRefresh",
	"arcon",
	"mMap",
	"iServer",
	"KKick",
	"qQuit",
	0,
};


char * send_moh_rcon(char *command) 
{

	char make_command[250];

	memset(make_command,'\0',sizeof(make_command));
	snprintf(make_command, sizeof make_command, "%c%c%c%c%cRCON %s %s",255,255,255,255,2, serv[cur_serv].rcon_password,command );
	return(sr_udp(make_command,RCON));
		
}

void proc_moh_dgram(char *dgram) 
{
	int i;
	int d;
	int pi;
	char tbuf[250];
	char Delim = '\\';
	char *t;
	char *dgrambuf[500];


	memset(tbuf,'\0',sizeof(tbuf));

	for (i= 0 ; i < 500 ; i++) {
		dgrambuf[i] = (char *) malloc(50);
		if (dgrambuf[i] == NULL) {
			printf("Memory allocation failed\n");
		}
		else {
			memset(dgrambuf[i],'\0',50);
		}
	}



	d = split( dgram, dgrambuf, Delim, 500, 50 );

	i=1;
	pi=0;
	while(!strstr(dgrambuf[i],"final")) {
		//fprintf(stderr,"%s -> %s\n",dgrambuf[i], dgrambuf[i+1]);

		if(strstr(dgrambuf[i], "gamever")) 
			strlcpy(bfsi.gamever,dgrambuf[i+1],sizeof(bfsi.gamever));
		else if(strstr(dgrambuf[i], "gamename"))
			strlcpy(bfsi.gamename,dgrambuf[i+1],sizeof(bfsi.gamename));
		else if(strstr(dgrambuf[i], "reservedslot"))
			bfsi.reservedslots = atoi(dgrambuf[i+1]);
		else if(strstr(dgrambuf[i], "version"))
			strlcpy(bfsi.version,dgrambuf[i+1],sizeof(bfsi.version));
		else if(strstr(dgrambuf[i], "hostport"))
			strlcpy(bfsi.hostport,dgrambuf[i+1],sizeof(bfsi.hostport));
		else if(strstr(dgrambuf[i], "mapname"))
			strlcpy(bfsi.mapname,dgrambuf[i+1],sizeof(bfsi.mapname));
		else if(strstr(dgrambuf[i], "gametype"))
			strlcpy(bfsi.gametype,dgrambuf[i+1],sizeof(bfsi.gametype));
		else if(strstr(dgrambuf[i], "Soldier Friendly"))
			strlcpy(bfsi.SoldierFF,dgrambuf[i+1],sizeof(bfsi.SoldierFF));
		else if(strstr(dgrambuf[i], "Vehicle Friendly"))
			strlcpy(bfsi.VehicleFF,dgrambuf[i+1],sizeof(bfsi.VehicleFF));
		else if(strstr(dgrambuf[i], "password")) {
			if(atoi(dgrambuf[i+1]) == 0)
				bfsi.password = false;	
			if(atoi(dgrambuf[i+1]) == 1)
				bfsi.password = true;	
		}
		else if(strstr(dgrambuf[i], "dedicated")) {
			if(atoi(dgrambuf[i+1]) == 0)
				bfsi.dedicated = false;	
			if(atoi(dgrambuf[i+1]) == 1)
				bfsi.dedicated = true;	
		}
		else if(strstr(dgrambuf[i], "hostname"))
			strlcpy(bfsi.hostname,dgrambuf[i+1],sizeof(bfsi.hostname));
		else if(strstr(dgrambuf[i], "maxplayers"))
			strlcpy(bfsi.maxplayers,dgrambuf[i+1],sizeof(bfsi.maxplayers));
		else if(strstr(dgrambuf[i], "numplayers")) 
			strlcpy(bfsi.numplayers,dgrambuf[i+1],sizeof(bfsi.numplayers));


		if(strstr(dgrambuf[i],"team_")) {
			t = strchr(dgrambuf[i],'_');

			for(pi=0;pi<MAX_BFPLAYERS;pi++) {
				if(bfp[pi].set ) {
					if(bfp[pi].num == atoi(t+1)) {
						strlcpy(bfp[pi].team,dgrambuf[i+1],sizeof(bfp[pi].team));
						break;
					}
				}
				else {
					bfp[pi].set = true;
					bfp[pi].num = atoi(t+1);
					strlcpy(bfp[pi].team,dgrambuf[i+1],sizeof(bfp[pi].team));
					break;
				}
			}	
		

		}
		else if(strstr(dgrambuf[i],"ping_")){
			t = strchr(dgrambuf[i],'_');

			for(pi=0;pi<MAX_BFPLAYERS;pi++) {
				if(bfp[pi].set ) {
					if(bfp[pi].num == atoi(t+1)) {
						strlcpy(bfp[pi].ping,dgrambuf[i+1],sizeof(bfp[pi].ping));
						break;
					}
				}
				else {
					bfp[pi].set = true;
					bfp[pi].num = atoi(t+1);
					strlcpy(bfp[pi].ping,dgrambuf[i+1],sizeof(bfp[pi].ping));
					break;
				}
			}


		}
		else if(strstr(dgrambuf[i],"score_")){
			t = strchr(dgrambuf[i],'_');

			for(pi=0;pi<MAX_BFPLAYERS;pi++) {
				if(bfp[pi].set ) {
					if(bfp[pi].num == atoi(t+1)) {
						strlcpy(bfp[pi].score,dgrambuf[i+1],sizeof(bfp[pi].score));
						break;
					}
				}
				else {
					bfp[pi].set = true;
					bfp[pi].num = atoi(t+1);
					strlcpy(bfp[pi].score,dgrambuf[i+1],sizeof(bfp[pi].score));
					break;
				}
			}



		}
		else if(strstr(dgrambuf[i],"deaths_")){
			t = strchr(dgrambuf[i],'_');
			
			for(pi=0;pi<MAX_BFPLAYERS;pi++) {
				if(bfp[pi].set ) {
					if(bfp[pi].num == atoi(t+1)) {
						strlcpy(bfp[pi].deaths,dgrambuf[i+1],sizeof(bfp[pi].deaths));
						break;
					}
				}
				else {
					bfp[pi].set = true;
					bfp[pi].num = atoi(t+1);
					strlcpy(bfp[pi].deaths,dgrambuf[i+1],sizeof(bfp[pi].deaths));
					break;
				}
			}



		}
		else if(strstr(dgrambuf[i],"frags_")){
			t = strchr(dgrambuf[i],'_');
			
			for(pi=0;pi<MAX_BFPLAYERS;pi++) {
				if(bfp[pi].set ) {
					if(bfp[pi].num == atoi(t+1)) {
						strlcpy(bfp[pi].frags,dgrambuf[i+1],sizeof(bfp[pi].frags));
						break;
					}
				}
				else {
					bfp[pi].set = true;
					bfp[pi].num = atoi(t+1);
					strlcpy(bfp[pi].frags,dgrambuf[i+1],sizeof(bfp[pi].frags));
					break;
				}
			}




		}
		else if(strstr(dgrambuf[i],"player_")) {
			t = strchr(dgrambuf[i],'_');
			
			for(pi=0;pi<MAX_BFPLAYERS;pi++) {
				if(bfp[pi].set ) {
					if(bfp[pi].num == atoi(t+1)) {
						strlcpy(bfp[pi].name,dgrambuf[i+1],sizeof(bfp[pi].name));
						break;
					}
				}
				else {
					bfp[pi].set = true;
					bfp[pi].num = atoi(t+1);
					strlcpy(bfp[pi].name,dgrambuf[i+1],sizeof(bfp[pi].name));
					break;
				}
			}




		}

		i = i + 2;
	}


}


