/* 
 * Copyright (C) 2003  Sam Vaughan
 * yamaneko@centurytel.net
 * 
 * File: procldgram.c
 * This file is part of Vrcon
 *
 * Vrcon
 * VaughanTech's  remote control for Cstrike and other Half-Life MODS
 * (rcon from a terminal)
 * 
 * Written by Sam "Jack Bauer" Vaughan
 *
 *
 *
 * Licensed under the GNU General Public License
 *
 * Vrcon is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * Vrcon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Vrcon; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/


#include "sv.h"

/* 
 * Process the received datagram
 * strip its junk
 * procldgram will cat into buf, dgram. buf needs to be able to
 * hold all of dgram, plus any additional calls to get more dgrams.
 * If buf is to small, the data from dgram will be truncated.
 * size should be sizeof(buf), the full size of buf 
 *  
 */

static int i = 0;	

int procldgram(char *buf, size_t bufsize, char *dgram, int dgramsize) 
{

	char *p = NULL;
	
	if (strstr(serv[cur_serv].game,"cod")) {
		p = strchr(dgram, '\n');	
		strlcat(buf,p+1, bufsize);   
	}
	else if (strstr(serv[cur_serv].game,"source") ) {


		for(i =0; i < dgramsize; i++) 
			if(dgram[i] == '\0')
				dgram[i] = '\n';
			//fputc(dgramR[i],stderr);

		strlcat(buf,dgram, bufsize);   
	}
	else if (strstr(serv[cur_serv].game,"hlife")) {

		if(dgram[0] == '\xff') {
			strlcat(buf,dgram+5, bufsize);  
		}
		else if(dgram[0] == '\xfe') {
			strlcat(buf,dgram+9, bufsize);   
		}
		else 
		{
			strlcat(buf,dgram, bufsize);   
		}
	}
	else {
			strlcat(buf,dgram, bufsize);   
	}
		
	return 0;
}

