/* 
 * Copyright (C) 2003  Sam Vaughan <yamaneko@centurytel.net>
 *
 * File: quake3.c
 * This file is part of Vrcon
 *
 * Vrcon
 * VaughanTech's  remote control for Cstrike and other Half-Life MODS
 * (rcon from a terminal)
 * 
 * Written by Sam "Jack Bauer" Vaughan
 *
 *
 * Licensed under the GNU General Public License
 *
 * Vrcon is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * Vrcon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Vrcon; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
*/

#include "sv.h"
#include "rcon.h"
#include "quake3.h"
#include "config.h"


extern char *adminWONIDS[MAX_ADMINS];
extern int  TOTAL_ADMINS;

extern char *flagWONIDS[MAX_ADMINS];
extern int  TOTAL_FLAG;

extern char *flagIP[MAX_ADMINS];
extern int  TOTAL_IP;

extern q3_player q3p[];
extern int cur_q3p;

q3_server_info q3si;

char *q3_menu[] = 
{
	"sRefresh",
	"arcon",
	"mMap",
	"KKick",
	"iServer",
#ifdef PUNKBUSTER
	"ppb_pblist",
	"Ppb_ss",
#endif 
	"qQuit",
	0,
};

char * send_q3_rcon(char *command)
{
	char make_command[250];

	memset(make_command,'\0',sizeof(make_command));
	snprintf(make_command, sizeof make_command, "%c%c%c%crcon %s %s",255,255,255,255, serv[cur_serv].rcon_password,command );
	return(sr_udp(make_command,RCON));

}

void proc_q3_dgram(char *hostd)
{
	int i;
	int d;
	int pi;
	int tqni =0;
	int tqnx =0;
	char tqn[100];
	char tqnbuff[100];
	static char buf[MAX_ENTRY];
	char tbuf[250];
	char Delim = '\\';
	char *np;
	char *lnp;
	char *dgrambuf[500];


	memset(buf,'\0',sizeof(buf));
	memset(tbuf,'\0',sizeof(tbuf));
	strlcpy(buf,hostd,sizeof(buf));

	for (i= 0 ; i < 500 ; i++) {
		dgrambuf[i] = (char *) malloc(50);
		if (dgrambuf[i] == NULL) {
			printf("Memory allocation failed\n");
		}
		else {
			memset(dgrambuf[i],'\0',50);
		}
	}


	for(i=0;i<strlen(buf);i++) {
		if(buf[i] == '\n') 
			buf[i] = '\\';
	}

	d = split( buf, dgrambuf, Delim, 500, 50 );

	i=1;
	pi=0;

	
	for(i=0;i<=d;i++) {

		if(strstr(dgrambuf[i], "version")) 
			strlcpy(q3si.version,dgrambuf[i+1],sizeof(q3si.version));
		else if(strstr(dgrambuf[i], "hostname"))
			strlcpy(q3si.hostname,dgrambuf[i+1],sizeof(q3si.hostname));
		else if(strstr(dgrambuf[i], "gamename"))
			strlcpy(q3si.gamename,dgrambuf[i+1],sizeof(q3si.gamename));
		else if(strstr(dgrambuf[i], "sv_maxclients"))
			strlcpy(q3si.maxplayers,dgrambuf[i+1],sizeof(q3si.maxplayers));
		else if(strstr(dgrambuf[i], "mapname"))
			strlcpy(q3si.mapname,dgrambuf[i+1],sizeof(q3si.mapname));
		else if(strstr(dgrambuf[i], "g_gametype"))
			strlcpy(q3si.gametype,dgrambuf[i+1],sizeof(q3si.gametype));
		else if(strstr(dgrambuf[i], "sv_punkbuster")) {
			if(atoi(dgrambuf[i+1]) == 0)
				strlcpy(q3si.punkbuster,"Off",sizeof(q3si.punkbuster));
			if(atoi(dgrambuf[i+1]) == 1)
				strlcpy(q3si.punkbuster,"On",sizeof(q3si.punkbuster));
		}
		else if(strstr(dgrambuf[i], " \"")) {

			for(pi=0;pi<MAX_Q3PLAYERS;pi++) {
				if(!q3p[pi].set ) {
					q3p[pi].set = true;

					/* Name */	
					np = strchr(dgrambuf[i],'"');
					lnp = strrchr(dgrambuf[i],'"');
					*lnp = '\0';

					/* Clean up any color codes */
					memset(tqn,'\0',sizeof(tqn));
					memset(tqnbuff,'\0',sizeof(tqnbuff));
					strlcpy(tqnbuff,np+1,sizeof(tqnbuff));

					for(tqni=0,tqnx = 0;tqni<strlen(tqnbuff);tqni++) 
						if(tqnbuff[tqni] == '^') {
							tqni++;
						}
						else {
							tqn[tqnx++] = tqnbuff[tqni];
						}


					strlcpy(q3p[pi].name,tqn,sizeof(q3p[pi].name));
					//strlcpy(q3p[pi].name,np+1,sizeof(q3p[pi].name));

					/* Ping */	
					*np = '\0';
					lnp = strrchr(dgrambuf[i],' ');
					*lnp = '\0';
					np = strchr(dgrambuf[i],' ');
					strlcpy(q3p[pi].ping,np+1,sizeof(q3p[pi].ping));

					/* Score */ 
					lnp = np;
					*lnp = '\0';
					strlcpy(q3p[pi].score,dgrambuf[i],sizeof(q3p[pi].score));

					/* Num of Players */
					snprintf(q3si.numplayers,sizeof(q3si.numplayers),"%d",pi+1);
					break;

				}
			}
		}
	}


}


