/* 
 * Copyright (C) 2003  Sam Vaughan <yamaneko@centurytel.net>
 *
 * File: quake3.h
 * This file is part of Vrcon
 *
 * Vrcon
 * VaughanTech's  remote control for Cstrike and other Half-Life MODS
 * (rcon from a terminal)
 * 
 * Written by Sam "Jack Bauer" Vaughan
 *
 *
 * Licensed under the GNU General Public License
 *
 * Vrcon is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * Vrcon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Vrcon; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
*/


#ifndef _QUAKE3_H
#define _QUAKE3_H


#define MAX_Q3PLAYERS 40

typedef struct {
	bool set; 
	char name[100];
	char frags[4];
	char score[6];
	char ping[5];
	char ip[25];
	int num;
}q3_player;

typedef struct {
	char hostname[250];
	char version[250];
	char gamename[25];
	char maxplayers[25];
	char numplayers[25];
	char mapname[100];
	char hostport[10];
	char punkbuster[10];
	char gametype[5];
	char ip[25];
	char map[50];
}q3_server_info;

q3_player q3p[MAX_Q3PLAYERS];
int cur_q3p;

void proc_q3_dgram(char *hostd);
char *  cod_gametype_box(void);
char *  cod_mbox(char *g);



#endif /* _QUAKE3_H */
