/* 
 * Copyright (C) 2003  Sam Vaughan
 * yamaneko@centurytel.net
 * 
 * File: rcon.c
 * This file is part of Vrcon
 *
 * Vrcon
 * VaughanTech's  remote control for Cstrike and other Half-Life MODS
 * (rcon from a terminal)
 * 
 * Written by Sam "Jack Bauer" Vaughan
 *
 *
 *
 * Licensed under the GNU General Public License
 *
 * Vrcon is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * Vrcon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Vrcon; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

#include "rcon.h"
#include "sv.h"


int s;	/* Socket */
bool fail;

extern long r_timeout_sec;
extern long r_timeout_usec;
extern servers serv[];
extern int cur_serv;

void signal_handler(int signum) 
{
	switch(signum) {
		case SIGINT:
			fail = true;
			close(s);	
		break;

	//	default:
	}

}

char * get_status(char *command) 
{
	return(sr_udp(command, STATUS));
}


char * send_hlife_rcon(char *command) 
{
	int i;
	int l;
	static char dgram[2000]; /* recieve buffer */
	char challenge[100];
	char *chall_p;
	char *p;

	fail = false;

	memset (dgram, '\0', sizeof(dgram));	
	snprintf(dgram, sizeof dgram, "\xff\xff\xff\xff\x63\x68\x61\x6c\x6c\x65\x6e\x67\x65\x20\x72\x63\x6f\x6e\x0a" );

	/*  Send challange */
	chall_p = sr_udp(dgram, RCON);	
	if(chall_p == NULL )
		return NULL;

	/*  create and send challange+command */
		memset (challenge, '\0', sizeof(challenge));	
		p = strrchr(chall_p, ' ');
		if(p == NULL)
			return NULL;

		l = strlen(p);
	
		for(i=0; i < l;i++) {
			if(p[i] == '\n')
				p[i] = '\0';
		}
			
		strlcpy(challenge, p, sizeof(challenge));
		memset (dgram, '\0', sizeof(dgram));	
		snprintf(dgram, sizeof dgram, "\xff\xff\xff\xff rcon %s \"%s\"%s", challenge,serv[cur_serv].rcon_password, command );
		
		return(sr_udp(dgram, RCON));

}


/* Send and Receive UDP datagrams 
 */

char * sr_udp(char *command, int SRPFLAG)
{
	int z;	
	int x;
	int retval;
	struct sockaddr_in adr_srv;
	struct sockaddr_in adr;
	int len_inet;
	static char dgramR[15000];
	static char retbuf[MAX_RETBUF];

	fd_set rfds;
	struct timeval tv;



	fail = false;

	memset(retbuf,'\0',sizeof (retbuf));
	memset(&adr_srv,'\0',sizeof adr_srv);
	adr_srv.sin_family = AF_INET;


	if(SRPFLAG == STATUS) {
		adr_srv.sin_port = htons(serv[cur_serv].cs_server_port);
	} 
	else if(SRPFLAG == RCON) {
		adr_srv.sin_port = htons(serv[cur_serv].rcon_port);
	}


	adr_srv.sin_addr.s_addr = inet_addr(serv[cur_serv].cs_server_addr);
	
	if( adr_srv.sin_addr.s_addr == INADDR_NONE ) {
		perror("Bad Address");
		return NULL;
	}

	len_inet = sizeof adr_srv;

	/*
		Create UDP socket to use 
	*/

	s = socket(AF_INET,SOCK_DGRAM,0);
	if(s == -1)
		return NULL;

	signal(SIGINT, signal_handler);
	z = strlen(command);
	if(z > 0 && command[--z] == '\n' )
		command[z] = 0;

	/*  Send rcon */
	z = sendto(s, command, strlen(command),0, (struct sockaddr *)&adr_srv, len_inet);
	if((z < 0 ) || (fail))
		return NULL;

	x = sizeof adr;

	/*  recieve  challange */
	FD_ZERO(&rfds);
	FD_SET(s,&rfds);

	//tv.tv_sec = r_timeout_sec;  
	tv.tv_sec = 2;  // Set timeout
	tv.tv_usec =  r_timeout_usec;


	memset (dgramR, '\0', sizeof(dgramR));	
	while ((retval = select(s+1,&rfds,NULL,NULL,&tv))) {
		z = recvfrom(s, dgramR, sizeof(dgramR), 0, (struct sockaddr *)&adr, &x);
		if((z < 0 ) || (fail))
			return NULL;
			
		procldgram( retbuf,sizeof(retbuf), dgramR, z);
		memset (dgramR, '\0', sizeof(dgramR));	
		tv.tv_sec = r_timeout_sec;  // Set timeout
		tv.tv_usec =  r_timeout_usec;
	}

	if((retval == -1) || (retbuf[0] == '\0'))  
		return NULL;

	return retbuf;

	close(s);

}

char * send_source_rcon(char *command)
{
	int z;	
	int retval;
	int len_inet;
	static char packetR[15000];
	static char retbuf[MAX_RETBUF];
	unsigned char auth_buf[250];
	unsigned char *auth_ptr = auth_buf + sizeof(int);
	struct timeval tv;
	struct sockaddr_in adr_srv;
	fd_set rfds;

	fail = false;

	memset(retbuf,'\0',sizeof (retbuf));
	memset(&adr_srv,'\0',sizeof adr_srv);

	adr_srv.sin_family = AF_INET;
	adr_srv.sin_addr.s_addr = inet_addr(serv[cur_serv].cs_server_addr);
	adr_srv.sin_port = htons(serv[cur_serv].rcon_port);
	
	if( adr_srv.sin_addr.s_addr == INADDR_NONE ) {
		perror("Bad Address");
		return NULL;
	}

	len_inet = sizeof adr_srv;

	/*
		Create TCP socket to use 
	*/

	s = socket(AF_INET,SOCK_STREAM,IPPROTO_TCP);
	if(s == -1)
		return NULL;

	signal(SIGINT, signal_handler);
	z = strlen(command);
	if(z > 0 && command[--z] == '\n' )
		command[z] = 0;

        if ( connect( s,(const struct sockaddr *)&adr_srv, sizeof( adr_srv ) )!= 0 )
        {
                fprintf(stderr, "Unable to connect\n");
		return NULL;
        }


	/*
	 *  Create and send AUTH
	 */

        *(int *)auth_ptr = 0x0001; 
        auth_ptr += sizeof(int);
        *(int *)auth_ptr = 0x0003; //id 3 =  AUTH
        auth_ptr += sizeof(int);
        
        strlcpy( (char *)auth_ptr, serv[cur_serv].rcon_password, sizeof(serv[cur_serv].rcon_password ) ); 
        auth_ptr += strlen(serv[cur_serv].rcon_password) +1; 
        *(int *)auth_ptr = 0; // 2nd string null
        auth_ptr++;
        (*(int *)auth_buf) = (int)(auth_ptr - auth_buf - sizeof(int));


	/* Send the request */
        z = send( s, auth_buf, *(int *)(auth_buf) + sizeof(int), 0 ); 
	if((z < 0 ) || (fail))
		return NULL;

	FD_ZERO(&rfds);
	FD_SET(s,&rfds);
	tv.tv_sec = r_timeout_sec;  // Set timeout
	tv.tv_usec =  r_timeout_usec;


	memset (packetR, '\0', sizeof(packetR));	
	retval = select(s+1,&rfds,NULL,NULL,&tv);
/* 
 * FIXME 
 * Under OSX select returns 0 
 */

//fprintf(stderr, "GOT HERE %d   ret = %d\n", __LINE__, retval) ;
	z = recv(s, packetR, sizeof(packetR), 0);
	if((z < 0 ) || (fail))
		return NULL;
//fprintf(stderr, "GOT HERE %d   ret = %d\n", __LINE__, retval) ;

	memset(auth_buf, '\0', sizeof(auth_buf));
	auth_ptr = auth_buf + sizeof(int);
        *(int *)auth_ptr = 0x0001; 
        auth_ptr += sizeof(int);
        *(int *)auth_ptr = 0x0002; //id 2 =  EXEC COMMAND
        auth_ptr += sizeof(int);
        
        strlcpy( (char *)auth_ptr, command, sizeof(auth_buf)); 
        auth_ptr += strlen(command) +1; 
        *(int *)auth_ptr = 0; // 2nd string null
        auth_ptr++;
        (*(int *)auth_buf) = (int)(auth_ptr - auth_buf - sizeof(int));

	/* Send the request */
        z = send( s, auth_buf, *(int *)(auth_buf) + sizeof(int), 0 ); 
	if((z < 0 ) || (fail))
		return NULL;

	tv.tv_sec = r_timeout_sec;  // Set timeout
	tv.tv_usec =  r_timeout_usec;

	memset (packetR, '\0', sizeof(packetR));	

	while ((retval = select(s+1,&rfds,NULL,NULL,&tv))) {
		z = recv(s, packetR, sizeof(packetR), 0);
		if((z < 0 ) || (fail))
			return NULL;
			
		//procldgram( retbuf,sizeof(retbuf), packetR, z);
		strlcat( retbuf,packetR+12,sizeof(retbuf));
		memset (packetR, '\0', sizeof(packetR));	
		tv.tv_sec = r_timeout_sec;  // Set timeout
		tv.tv_usec =  r_timeout_usec;
	}

	return retbuf;

	close(s);

}
