/* 
 * Copyright (C) 2003  Sam Vaughan <yamaneko@centurytel.net>
 *
 * File: rcon.h
 * This file is part of Vrcon
 *
 * Vrcon
 * VaughanTech's  remote control for Cstrike and other Half-Life MODS
 * (rcon from a terminal)
 * 
 * Written by Sam "Jack Bauer" Vaughan
 *
 *
 * Licensed under the GNU General Public License
 *
 * Vrcon is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * Vrcon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Vrcon; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
*/


#ifndef _RCON_H
#define _RCON_H

#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#ifdef __MACH__
#include <sys/time.h>
#else
#include <time.h>
#endif
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>


char * get_status(char *command); 
char * send_hlife_rcon(char * command);	
char * send_source_rcon(char *command);
char * sr_udp(char *command, int SRPFLAG);

#endif /* _RCON_H */
