/* 
 * Copyright (C) 2003  Sam Vaughan <yamaneko@centurytel.net>
 *
 * File: source.c
 * This file is part of Vrcon
 *
 * Vrcon
 * VaughanTech's  remote control for Cstrike and other Half-Life MODS
 * (rcon from a terminal)
 * 
 * Written by Sam "Jack Bauer" Vaughan
 *
 *
 * Licensed under the GNU General Public License
 *
 * Vrcon is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * Vrcon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Vrcon; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
*/


#include "sv.h"
#include "rcon.h"
#include "source.h"
#include "config.h"

int s;	/* Socket */
bool fail;

extern long r_timeout_sec;
extern long r_timeout_usec;
extern servers serv[];
extern int cur_serv;


extern char *adminWONIDS[MAX_ADMINS];
extern int  TOTAL_ADMINS;

extern char *flagWONIDS[MAX_ADMINS];
extern int  TOTAL_FLAG;

extern char *flagIP[MAX_ADMINS];
extern int  TOTAL_IP;

extern source_player sourcep[];
extern int cur_sourcep;

source_server_info sourcesi;

char *source_menu[] = 
{
	"sRefresh",
	"arcon",
	"mMap",
	"iServer",
	"jKick",
	"kBan 1 Min",
	"lBan 30 Min",
	"bBan Perm",
	"qQuit",
	0,
};


char * get_source_players(void)
{
	return(sr_udp("\xff\xff\xff\xff\x55",STATUS));
}

char * get_source_status(void)
{
	return(sr_udp("\xff\xff\xff\xff\x54",STATUS));
}

void proc_source_players(char *dgram) 
{

	int i;
	int x;
	int z;
	int player_index = 0;	
	static char buf[MAX_ENTRY];
	char tbuf[250];
	char *qp1;
	char *qp2;
	char *sp;

	memset(buf,'\0',sizeof(buf));
	memset(tbuf,'\0',sizeof(tbuf));
	strlcpy(buf,dgram,sizeof(buf));

	for(i=0,x=0;i<strlen(buf);i++,x++) {
		if(buf[i] == '\n') {

			switch(tbuf[0]) {
				case '#':

				// Get player

				qp1 = strchr(tbuf, '"');
				if(qp1 == NULL)
					break;
				qp1++;
				qp2 = strrchr(tbuf, '"');
				*qp2 = '\0';

				for(z=0;z<MAX_SOURCE_PLAYERS;z++) {
					if (strstr(sourcep[z].name, qp1)) {
						player_index = z;
					}
				}

				qp2 += 2;
				sp = strchr(qp2, ' ');
				*sp = '\0';
	
				// STEAM ID
				strlcpy(sourcep[player_index].wonid, qp2, sizeof(sourcep[player_index].wonid));	
				
				sp++;
				qp1 = strrchr(sp, ' ');
				qp1++;
				qp2 = strchr(qp1,':');
				*qp2 = '\0';
				strlcpy(sourcep[player_index].ip, qp1, sizeof(sourcep[player_index].ip));	


				break;

			}

			memset(tbuf,'\0',sizeof(tbuf));
			x=-1;
		}
		else
			tbuf[x] = buf[i];
	}



}


void proc_source_dgram(char *hostd)
{
	int i;
	int x;
	int tlen;
	int tbuf_count;
	char tbuf[250];
	char type = 'U'; 
	static unsigned char buf[MAX_ENTRY];

	int nump; 
	char *startpl;
	char *tpl;

	int tint; 


	memset(buf,'\0',sizeof(buf));
	strlcpy(buf,hostd,sizeof(buf));


	 // Determin type of packat
	type = buf[4];	
	switch (type) {

		case	'I':

			// REWRITE THIS SECTION!!!
			tbuf_count = 0;
			for(i=0,x=0;i<strlen(buf);i++,x++) {
					if(buf[i] == '\n') {
						tbuf_count++;

					if(tbuf_count == 1) {
						if(isascii(tbuf[strlen(tbuf)-1]) == 0)   // Zero if it is not
							tbuf[strlen(tbuf)-2] = '\0';
						strlcpy(sourcesi.hostname, tbuf+6,sizeof(sourcesi.hostname));
					}
					if(tbuf_count == 2)
						strlcpy(sourcesi.map, tbuf,sizeof(sourcesi.map));
					if(tbuf_count > 5) {
						if(tbuf != NULL) {
							if(sourcesi.max_players[0] == '\0') {
								tlen = strlen(tbuf);
								if(tlen == 1) {
									snprintf(sourcesi.max_players, sizeof(sourcesi.max_players), "%d", tbuf[0]);
								}
								else if(tlen == 2) {
									snprintf(sourcesi.players, sizeof(sourcesi.players), "%d", tbuf[0]);
									snprintf(sourcesi.max_players, sizeof(sourcesi.max_players), "%d", tbuf[1]);
								}
							}
						}
					}

					memset(tbuf,'\0',sizeof(tbuf));
					x=-1;
				}
				else
					tbuf[x] = buf[i];

			}


		break;
			case 	'D':

				if(buf[5] == '\n')
					nump = 0;
				else	
					nump = buf[5];

			//	fprintf(stderr, "BEGIN ----------------\n");
			//	fprintf(stderr, "Num Players -> [%d]\n",nump);

				if(nump > 0) {
					
					startpl = &buf[6];
					for(i=0; i < nump; i++) {
			
				//		fprintf(stderr, "i = %d  Client Num -> [%d]\n",i,*startpl);
						startpl++;
						tpl = strchr(startpl, '\n');
						if( tpl) {
							*tpl = '\0';	
							sourcep[i].set = true;
						}
						else 
							break;
				//		fprintf(stderr, "Player Name -> [%s]\n",startpl);
						strlcpy(sourcep[i].name, startpl, sizeof(sourcep[i].name));	
						//startpl = (startpl + strlen(startpl)+1);	
						startpl = tpl+1;
						if(*startpl == '\n')
							tint = 0;
						else 
							tint = *startpl;
				//		fprintf(stderr, "Frag Total -> [%d]\n",tint);
						snprintf(sourcep[i].frags, sizeof(sourcep[i].frags), "%d",tint);	
						startpl += sizeof(int) ;

						//fprintf(stderr, "Time Online -> [%f]\n",tfloat);
						startpl += sizeof(float);
				//		fprintf(stderr, "END ----------------\n\n");
					}
				}




		break;
		

	}


}


