/* 
 * Copyright (C) 2003  Sam Vaughan <yamaneko@centurytel.net>
 *
 * File: source.h
 * This file is part of Vrcon
 *
 * Vrcon
 * VaughanTech's  remote control for Cstrike and other Half-Life MODS
 * (rcon from a terminal)
 * 
 * Written by Sam "Jack Bauer" Vaughan
 *
 *
 * Licensed under the GNU General Public License
 *
 * Vrcon is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * Vrcon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Vrcon; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
*/


#ifndef _SOURCE_H
#define _SOURCE_H

// start off at 20
#define MAX_SOURCE_PLAYERS 20

typedef struct {
	char hostname[250];
	char version[250];
	char ip[25];
	char map[50];
	char players[4];
	char max_players[4];
}source_server_info;

typedef struct {
	bool set; 
	char name[100];
	char frags[10];
	char deaths[10];
	char ping[20];
	char ip[25];
	char wonid[MAX_WONID_LEN+1];
	char userid[20];
}source_player;

source_player sourcep[MAX_SOURCE_PLAYERS];
int cur_sourcep;

char * send_source_rcon(char *command);
char * get_source_players(void);
void proc_source_dgram(char *dgram);
void proc_source_players(char *dgram);

#endif /* _SOURCE_H */
