/* 
 * Copyright (C) 2003  Sam Vaughan <yamaneko@centurytel.net>
 *
 * File: split.c
 * This file is part of Vrcon
 *
 * Vrcon
 * VaughanTech's  remote control for Cstrike and other Half-Life MODS
 * (rcon from a terminal)
 * 
 * Written by Sam "Jack Bauer" Vaughan
 *
 *
 * Licensed under the GNU General Public License
 *
 * Vrcon is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * Vrcon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Vrcon; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
*/


#include "sv.h"

/*
 * split
 * will split *Line by Delim into *Buff[]. Will only split Maxnum
 * times and will only copy MaxLen in each array field.  
 */

int split( char *Line, char *Buff[], char Delim, int MaxNum, int MaxLen )
{
        int     a;
        int     j = 0;
        int     fc = 0;
        int     i = 0;

        i = 0;
        while( ((a = Line[j++] ) != '\0') && (a != EOF) ) {
                if( a == Delim ) {
                        fc++;
                        i = 0;
                }
		if(fc > (MaxNum -1)) 
			return fc;

                if((a != Delim) && (a!='\n') && (a!='\r') && (i < MaxLen) )
                        Buff[fc][i++]=(char) a;
        }
        return fc;
}

