/* 
 * Copyright (C) 2003  Sam Vaughan <yamaneko@centurytel.net>
 *
 * File: sv.h
 * This file is part of Vrcon
 *
 * Vrcon
 * VaughanTech's  remote control for Cstrike and other Half-Life MODS
 * (rcon from a terminal)
 * 
 * Written by Sam "Jack Bauer" Vaughan
 *
 *
 * Licensed under the GNU General Public License
 *
 * Vrcon is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * Vrcon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Vrcon; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
*/


#ifndef _SV_H
#define _SV_H

#define NUM 256
#define SNUM 8
#define MAXKEYLENGTH 1024
#define MAX_STRING 1024
#define MAX_ENTRY 5000
#define MAX_ADMINS 50
#define MAX_WONID_LEN 25
#define MAX_IP_LEN 17
#define MESSAGE_LINE 0
#define RETURN_LINE 21 
#define ERROR_LINE 7
#define Q_LINE 20
#define PROMPT_LINE 18
#define BOXED_LINES 11
#define BOXED_ROWS 60
#define BOX_LINE_POS 8
#define BOX_ROW_POS 2

#define MAX_PLAYERS 32
#define MAX_PLEN 250

#define MAX_RETBUF 15000
#define MAX_MAPS 1024
#define MAX_MAP_NAME 80
#define MAX_SERV 20

#define STATUS 0
#define RCON 1

#define VRCON_VERSION "0.9.9"

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>       
#include <curses.h>

#ifdef linux
#include <bfd.h>
#endif


#ifndef false
#define false 0
#endif

#ifndef true
#define true 1
#endif

/* Player info */ 

typedef struct {
	bool set; 
	char name[100];
	char userid[20];
	char wonid[MAX_WONID_LEN+1];
	char frags[4];
	char time[6];
	char ping[5];
	char loss[2];
	char ip[25];
}player;


/* Server info */ 

typedef struct {
	bool set; 
	char language[25];
	char gamever[10];
	char gamename[25];
	int reservedslots;
	int roundTime;
	char mapId[10];
	char version[10];
	bool dedicated;
	bool password;
	char gamemode[25];
	char maxplayers[25];
	char numplayers[25];
	char gametype[50];
	char mapname[100];
	char hostport[10];
	char hostname[50];
	int CPU;
	char Hit_Indicator[4];
	char TK_Mode[15];
	char VehicleFF[5];
	char SoldierFF[5];
	
}ea_server_info;

typedef struct {
	char hostname[250];
	char version[250];
	char ip[25];
	char map[50];
	char players[20];
}cstrike;



/* game servers */ 

typedef struct {

	bool set;
	char name[50];
	char cs_server_addr[16];
	int cs_server_port;
	char rcon_uname[25];
	int rcon_port; 		
	char rcon_password[50];
	int logmodport;
	char logmodkey[50];
	char game[10];		
}servers;

/* vlog */
struct {
	char cs_tcolor[3];
	char cs_ctcolor[3];
	char cs_bankick[3];
	char cs_rcon[3];
	char cs_say[3];
}vlogcolor; 

enum {
        gui,
        nogui
};

servers serv[MAX_SERV];
long r_timeout_sec;
long r_timeout_usec;
int cur_serv;

char config_path[MAX_STRING];
char cmsay_color[5]; 
char amxsay_color[15];

int get_confirm(char *message);
int vcon_sbox(void);
int vcon_listbox(void);
int rcon_command();
int list_status();
int start_log();
int split( char *Line, char *Buff[], char Delim, int MaxNum, int MaxLen );
int CmSayCommand(int type);
char * p_dgram(char *dgram); 
char * get_source_status(void);	
char * vcon_mbox(void);
char * process_dgram(char *dgram, char *players[MAX_PLAYERS]);
char * trim_b_space(char *s,char *tmpb);
int procldgram(char *buf, size_t bufsize, char *dgram, int dgramsize); 
void proc_line(char *line);
char * send_q3_rcon(char *command);
int load_config(void);
int  s_rcon_command();
void clear_all_screen(void);
void clear_sap(void);
void get_string(char *string);
void get_return();
void draw_menu(char *options[], int current_highlight, int start_row, int start_col);
void signal_handler(int signum);
size_t strlcat(char *dst, const char *src, size_t siz);
size_t strlcpy(char *dst, const char *src, size_t siz);



#endif /* _SV_H */
