/* 
 * Copyright (C) 2003  Sam Vaughan <yamaneko@centurytel.net>
 *
 * File: ut2k4.c
 * This file is part of Vrcon
 *
 * Vrcon
 * VaughanTech's  remote control for Cstrike and other Half-Life MODS
 * (rcon from a terminal)
 * 
 * Written by Sam "Jack Bauer" Vaughan
 *
 *
 * Licensed under the GNU General Public License
 *
 * Vrcon is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * Vrcon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Vrcon; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
*/

#include "sv.h"
#include "ut2k4.h"  // We can use the already existing data structures.
#include "config.h"


extern char *adminWONIDS[MAX_ADMINS];
extern int  TOTAL_ADMINS;

extern char *flagWONIDS[MAX_ADMINS];
extern int  TOTAL_FLAG;

extern char *flagIP[MAX_ADMINS];
extern int  TOTAL_IP;

ut2k4_server_info ut2si;

char *ut2_menu[] = 
{
	"sRefresh",
	"iServer",
	"qQuit",
	0,
};

void proc_ut2_dgram(char *dgram) 
{
	int i;
	int pi;
	int d;
	char tbuf[250];
	char Delim = '\\';
	char *t;
	char *dgrambuf[500];


	memset(tbuf,'\0',sizeof(tbuf));

	for (i= 0 ; i < 500 ; i++) {
		dgrambuf[i] = (char *) malloc(50);
		if (dgrambuf[i] == NULL) {
			printf("Memory allocation failed\n");
		}
		else {
			memset(dgrambuf[i],'\0',50);
		}
	}



	d = split( dgram, dgrambuf, Delim, 500, 50 );
	
	if(d == 0) {
		fprintf(stderr,"split returned 0!\n");
		exit(0);
	}
	


	i=1;
	while(!strstr(dgrambuf[i],"final")) {
//fprintf(stderr,"%s -> %s\n",dgrambuf[i], dgrambuf[i+1]);

		if(strstr(dgrambuf[i], "gamever")) 
			strlcpy(ut2si.version,dgrambuf[i+1],sizeof(ut2si.version));
		else if(strstr(dgrambuf[i], "hostport"))
			strlcpy(ut2si.port,dgrambuf[i+1],sizeof(ut2si.port));
		else if(strstr(dgrambuf[i], "mapname"))
			strlcpy(ut2si.map,dgrambuf[i+1],sizeof(ut2si.map));
		else if(strstr(dgrambuf[i], "gametype"))
			strlcpy(ut2si.game_type,dgrambuf[i+1],sizeof(ut2si.game_type));
		else if(strstr(dgrambuf[i], "password")) {
			if(atoi(dgrambuf[i+1]) == 0)
				ut2si.password = false;	
			if(atoi(dgrambuf[i+1]) == 1)
				ut2si.password = true;	
		}
		else if(strstr(dgrambuf[i], "hostname"))
			strlcpy(ut2si.hostname,dgrambuf[i+1],sizeof(ut2si.hostname));
		else if(strstr(dgrambuf[i], "maxplayers"))
			strlcpy(ut2si.max_players,dgrambuf[i+1],sizeof(ut2si.max_players));
		else if(strstr(dgrambuf[i], "numplayers")) 
			strlcpy(ut2si.num_players,dgrambuf[i+1],sizeof(ut2si.num_players));

		if(strstr(dgrambuf[i],"team_")) {
			t = strchr(dgrambuf[i],'_');

			for(pi=0;pi<MAX_UTPLAYERS;pi++) {
				if(utp[pi].set ) {
					if(utp[pi].num == atoi(t+1)) {
						strlcpy(utp[pi].team,dgrambuf[i+1],sizeof(utp[pi].team));
						break;
					}
				}
				else {
					utp[pi].set = true;
					utp[pi].num = atoi(t+1);
					strlcpy(utp[pi].team,dgrambuf[i+1],sizeof(utp[pi].team));
					break;
				}
			}

		}
		else if(strstr(dgrambuf[i],"ping_")){
			t = strchr(dgrambuf[i],'_');

			for(pi=0;pi<MAX_UTPLAYERS;pi++) {
				if(utp[pi].set ) {
					if(utp[pi].num == atoi(t+1)) {
						strlcpy(utp[pi].ping,dgrambuf[i+1],sizeof(utp[pi].ping));
						break;
					}
				}
				else {
					utp[pi].set = true;
					utp[pi].num = atoi(t+1);
					strlcpy(utp[pi].ping,dgrambuf[i+1],sizeof(utp[pi].ping));
					break;
				}
			}

		}
		else if(strstr(dgrambuf[i],"score_")){
			t = strchr(dgrambuf[i],'_');

			for(pi=0;pi<MAX_UTPLAYERS;pi++) {
				if(utp[pi].set ) {
					if(utp[pi].num == atoi(t+1)) {
						strlcpy(utp[pi].score,dgrambuf[i+1],sizeof(utp[pi].score));
						break;
					}
				}
				else {
					utp[pi].set = true;
					utp[pi].num = atoi(t+1);
					strlcpy(utp[pi].score,dgrambuf[i+1],sizeof(utp[pi].score));
					break;
				}
			}

		}
		else if(strstr(dgrambuf[i],"deaths_")){
			t = strchr(dgrambuf[i],'_');

			for(pi=0;pi<MAX_UTPLAYERS;pi++) {
				if(utp[pi].set ) {
					if(utp[pi].num == atoi(t+1)) {
						strlcpy(utp[pi].deaths,dgrambuf[i+1],sizeof(utp[pi].deaths));
						break;
					}
				}
				else {
					utp[pi].set = true;
					utp[pi].num = atoi(t+1);
					strlcpy(utp[pi].deaths,dgrambuf[i+1],sizeof(utp[pi].deaths));
					break;
				}
			}

		}
		else if(strstr(dgrambuf[i],"frags_")){
			t = strchr(dgrambuf[i],'_');

			for(pi=0;pi<MAX_UTPLAYERS;pi++) {
				if(utp[pi].set ) {
					if(utp[pi].num == atoi(t+1)) {
						strlcpy(utp[pi].frags,dgrambuf[i+1],sizeof(utp[pi].frags));
						break;
					}
				}
				else {
					utp[pi].set = true;
					utp[pi].num = atoi(t+1);
					strlcpy(utp[pi].frags,dgrambuf[i+1],sizeof(utp[pi].frags));
					break;
				}
			}


		}
		else if(strstr(dgrambuf[i],"player_") || (strstr(dgrambuf[i],"playername_"))) {
			t = strchr(dgrambuf[i],'_');

			for(pi=0;pi<MAX_UTPLAYERS;pi++) {
				if(utp[pi].set ) {
					if(utp[pi].num == atoi(t+1)) {
						strlcpy(utp[pi].name,dgrambuf[i+1],sizeof(utp[pi].name));
						break;
					}
				}
				else {
					utp[pi].set = true;
					utp[pi].num = atoi(t+1);
					strlcpy(utp[pi].name,dgrambuf[i+1],sizeof(utp[pi].name));
					break;
				}
			}
		}



		i = i + 2;
	}

}
