/* 
 * Copyright (C) 2003  Sam Vaughan <yamaneko@centurytel.net>
 *
 * File: ut2k4.h
 * This file is part of Vrcon
 *
 * Vrcon
 * VaughanTech's  remote control for Cstrike and other Half-Life MODS
 * (rcon from a terminal)
 * 
 * Written by Sam "Jack Bauer" Vaughan
 *
 *
 * Licensed under the GNU General Public License
 *
 * Vrcon is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * Vrcon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Vrcon; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
*/


#ifndef _UT2K4_H
#define _UT2K4_H

#define MAX_UTPLAYERS 40

typedef struct {
	char hostname[250];
	char version[250];
	char port[10];
	char map[50];
	char game_type[50];
	char game_mode[25];
	char players[20];
	char max_players[20];
	char num_players[25];
	bool password;
	char gamemode[25];
}ut2k4_server_info;

typedef struct {
	bool set; 
	char name[100];
	char frags[4];
	char deaths[4];
	char score[6];
	char ping[5];
	char team[3];
	int num;
}ut_player;

ut_player utp[MAX_UTPLAYERS];
int cur_utp;

void proc_ut2_dgram(char *dgram);


#endif /* _UT2K4_H */
