/* 
 * Copyright (C) 2003  Sam Vaughan <yamaneko@centurytel.net>
 *
 * File: vlog.c
 * This file is part of Vrcon
 *
 * Vrcon
 * VaughanTech's  remote control for Cstrike and other Half-Life MODS
 * (rcon from a terminal)
 * 
 * Written by Sam "Jack Bauer" Vaughan
 *
 *
 * Licensed under the GNU General Public License
 *
 * Vrcon is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * Vrcon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Vrcon; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
*/


#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#ifdef __MACH__
#include <sys/time.h>
#else
#include <time.h>
#endif
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "sv.h"
#include "rcon.h"
#include "moh.h"


int  vlog(char *command) ;
int watch_stdin(FILE *wl);
int action_watch_stdin(FILE *al);

extern char config_path[MAX_STRING];
extern long r_timeout_sec;
extern long r_timeout_usec;

extern servers serv[];
extern int cur_serv;

bool color = false;

//needed for signal_handler
bool fail = false;
int s;	/* Socket */



void p_version(void) 
{
	printf("vlog - %s\t Copyright (C) 2003 Sam Vaughan\n\n",VRCON_VERSION);
	printf("Written by Sam \"Jack Bauer\" Vaughan\n\n");

}

void p_usage(void) 
{
	printf("Usage: vlog [-h] [-v] [-C config file] [-S] [-s n] [-c] [-w <file>] [-a <file>] \n\n");
	printf("  -s n, Overide the default server. n is a numeric value. \n");
	printf("        1 would be the first server listed in your config file\n");
	printf("        2 would be the next one. etc etc.                     \n");
	printf("  -C config file>  Use config file instead of default ~/.vrcon.\n");
	printf("  -S,  Show severs from config file (and numbers for use with -s). \n");
	printf("  -c, Color output\n");
	printf("  -w <file>, watch stdin for strings that are in <file> \n");
	printf("  -a, <file>, Same as -w, but file also contains an action to be \n");
	printf("             taken when the string is matched\n");
	printf("  -h, list help, this text.\n");
	printf("  -v, show version.\n");
	printf("\n");

}

void signal_handler_vlog(int signum) 
{
	switch(signum) {
		case SIGINT:
			fail = true;
			close(s);	
		break;

	//	default:
	}

}

int main(int argc, char **argv) 
{

	int c;	
	int i;
	int x;
	int servnum;
	int mainret;
	char *ret;
	char *sep;
	char *tmpp;
	char tmpbuf[250];
	
	FILE *wl; 
	FILE *al; 


	for (i=0;i<MAX_SERV;i++){
		serv[i].set = false;
		memset(serv[i].name,'\0',sizeof(serv[i].name));
		memset(serv[i].cs_server_addr,'\0',sizeof(serv[i].cs_server_addr));
		serv[i].cs_server_port = 0;
		memset(serv[i].rcon_password,'\0',sizeof(serv[i].rcon_password));
		serv[i].logmodport = 0;
		memset(serv[i].logmodkey,'\0',sizeof(serv[i].logmodkey));
		memset(serv[i].game,'\0',sizeof(serv[i].game));
	}

	cur_serv = 0 ;

	memset(config_path,'\0', sizeof(config_path));
// One way of making sure we can overide the default config ....
	for (i=0; i<argc; i++) {
		if(strcmp(argv[i], "-C") == 0) {
			snprintf(config_path, sizeof(config_path),"%s",argv[i+1]);
			//printf("%d  %s  [%s]\n", argc, argv[i], argv[i+1]);
		}
	}

	load_config();
	
	while ((c = getopt(argc, argv, "C:cw:a:hvSs:")) != EOF) {
		switch((char)c) {
			case 'c':
				color = true;
			break;
			case 'C':
			break;
			case 'a':
				// Watch and then act on 
				if((al = fopen(argv[optind -1],"r")) == NULL)
				{
					printf("error %s\n",argv[optind -1]);
					exit(0);
				}

				action_watch_stdin(al);
				exit(0);

			break;
			case 'w':
				// log mode, read stdin 
				// Use 

				if((wl = fopen(argv[optind -1],"r")) == NULL)
				{
					printf("error %s\n",argv[optind -1]);
					exit(0);
				}

				watch_stdin(wl);
				exit(0);
			break;
			case 'h':
				p_usage();
				exit(0);
			case 'v':
				p_version();
				exit(0);
			break;
			case 'S':  
				 printf("\n");
				 for(i=0; i<MAX_SERV;i++) {
					 if(serv[i].set)
						 printf(" %d. %s  [%s]\n",i+1, serv[i].name, serv[i].game);
				 }
				 printf("\n");
				 exit(0);

			break;



			case 's':  /* select Server from config
				    * Overiding the default one
				   */ 
			
				  servnum = atoi(argv[optind -1]);			
				  servnum--;
				  if( (servnum < 0) || (servnum > MAX_SERV)) {
					printf("\n Not a valid server number, try again!\n\n");
					exit(1);
				  }
				  
				  if(serv[servnum].set) {
					  cur_serv = servnum ;
				  }
				  else {
					printf("\n Not a valid server number, try again!\n\n");
					exit(1);
				  }
			/*
				  if(strcmp(serv[servnum].game, "hlife") != 0) {
					printf("\n vlog can only be used with Half-Life based Games,... currently\n\n");
					exit(1);
				  }
			*/

			break;
			case '?':
				p_usage();
				exit(0);
			break;	
		}

	}

	memset(tmpbuf,'\0',sizeof(tmpbuf));	
	ret = send_hlife_rcon("logmod options");
	if(ret == NULL) {
		printf("Unable to connect to: \nserver -> %s \nIP -> %s\n",serv[cur_serv].name,serv[cur_serv].cs_server_addr); 
		exit(0);
	}

	for(x=0,i=0;i<strlen(ret);i++,x++) {
		if(ret[i] == '\n') {
			if(strstr(tmpbuf,"Port")) {
				sep = strchr(tmpbuf,':');		
				sep++;
				while(*sep == ' ') {
					sep++;
				}
				tmpp = strchr(sep,' ');
				if(tmpp)
					*tmpp = '\0';
				serv[cur_serv].logmodport = atoi(sep);
			}
			memset(tmpbuf,'\0',sizeof(tmpbuf));	
			x = -1;
		}
		else
			tmpbuf[x] = ret[i];

	}

	ret = send_hlife_rcon("logmod addtmp 1");

	sep = strchr(ret,':');
	if(!sep) {
		printf("Error talking to logmod, are you sure it is installed on this server? [%s]\n",serv[cur_serv].name); 
		exit(0);
	}
		
	for(i=0;i<strlen(sep);i++)
		if(sep[i] == '\n')
			sep[i] = '\0';

	strlcpy(serv[cur_serv].logmodkey,sep+2,sizeof(serv[cur_serv].logmodkey));	

	mainret = start_log();

	return 0;
}

int action_watch_stdin(FILE *al)
{

	int i;
	int ii;
	int xx;
	int maxi; 
	char *alb[50];  // A max of 50 to start with,  MAKE A DEFINE!!
	char albuf[256]; 
	char lbuff[2048];
	char tmpb[MAX_RETBUF +1]; 
	char lineb[256]; 
	char name[50]; 
	char command[50]; 
	char slot[10]; 
	char *tmpp; 
	char *tmpp2; 
	char *info = NULL;

	memset(albuf, '\0', sizeof(albuf)); 
	memset(tmpb, '\0', sizeof(tmpb)); 
	memset(lineb, '\0', sizeof(tmpb)); 
	memset(name, '\0', sizeof(name)); 
	memset(slot, '\0', sizeof(slot)); 
	memset(command, '\0', sizeof(command)); 

	for (i= 0 ; i < 50 ; i++) {
		alb[i] = (char *) malloc(50);
		if (alb[i] == NULL) {
			printf("Memory allocation failed\n");
		}
		else {
			memset(alb[i],'\0',50);
		}
	}

	i=0;
	while(fgets(albuf,255,al) != NULL)  {

		albuf[strlen(albuf) - 1] = '\0';

		if(i > 50)
			i = 50;

		switch(albuf[0])
		{
			case '#':
			case '\n':
			case ' ':
			case '\0':
			break;

			default:
				strlcpy(alb[i], albuf, 50);
				i++;
			break;
		}

	}

	maxi = i; 

	fclose(al);

	memset(lbuff,'\0', sizeof(lbuff));

	while (fgets(lbuff, sizeof(lbuff)-1, stdin)) {
		 lbuff[strlen(lbuff) - 1] = '\0';
	
		memset(tmpb, '\0', sizeof(tmpb)); 
		memset(lineb, '\0', sizeof(tmpb)); 
		memset(name, '\0', sizeof(name)); 
		memset(slot, '\0', sizeof(slot)); 

		for (i= 0 ; i < maxi ; i++) {

			if(strstr(lbuff,alb[i])) {

				printf("MATCH -> %s\n", lbuff);

				tmpp = strchr(lbuff, ':');				
				tmpp2 = strchr(tmpp+1, ':');				
				tmpp2--;
				*tmpp2  = '\0';
				strlcpy(name, tmpp+2, sizeof(name));
				// Now I need to get the slot number to kick
		
				// This is probably where the problem is, I need to check if 
				// this failed and info is null. 
				info = send_moh_rcon("status");	
				strlcpy(tmpb,info,sizeof(tmpb));
				for(ii=0,xx=0;ii<strlen(tmpb);ii++,xx++) {
					if(tmpb[ii] == '\n') {

						if(strstr(lineb,name)) {
							snprintf(slot, sizeof(slot), "%.*s",3, lineb);
							//snprintf(command, sizeof(command), "say %s has selected a rocket launcher and will be kicked",name);
							//send_moh_rcon(command);	
							sleep(1);
							memset(command, '\0', sizeof(command));
							snprintf(command, sizeof(command), "clientkick %s",slot);
							send_moh_rcon(command);	
							printf("%s in slot %s has been kicked for selecting a rocket launcher\n", name, slot);

						}
					
						
						memset(lineb,'\0',sizeof(lineb));
						xx=-1;
					}
					else
						lineb[xx] = tmpb[ii];
				}
	
			}

		}

	}

	return(0);
}


int watch_stdin(FILE *wl)
{

	int i;
	int maxi; 
	char *wlb[50];  // A max of 50 to start with,  MAKE A DEFINE!!
	char wlbuf[256]; 
	char lbuff[2048];
	memset(wlbuf, '\0', sizeof(wlbuf)); 

	for (i= 0 ; i < 50 ; i++) {
		wlb[i] = (char *) malloc(50);
		if (wlb[i] == NULL) {
			printf("Memory allocation failed\n");
		}
		else {
			memset(wlb[i],'\0',50);
		}
	}

	i=0;
	while(fgets(wlbuf,255,wl) != NULL)  {

		wlbuf[strlen(wlbuf) - 1] = '\0';

		if(i > 50)
			i = 50;

		switch(wlbuf[0])
		{
			case '#':
			case '\n':
			case ' ':
			case '\0':
			break;

			default:
				strlcpy(wlb[i], wlbuf, 50);
				i++;
			break;
		}

	}

	maxi = i; 

	fclose(wl);

	memset(lbuff,'\0', sizeof(lbuff));

	while (fgets(lbuff, sizeof(lbuff)-1, stdin)) {
		 lbuff[strlen(lbuff) - 1] = '\0';
	
		for (i= 0 ; i < maxi ; i++) {

			if(strstr(lbuff,wlb[i])) {
				printf("%s\n", lbuff);
			}

		}
	}

	return(0);
}

int  start_log() 
{
	int z;	
	int x;
	int retval;
	struct sockaddr_in adr_srv;
	struct sockaddr_in adr;

	int len_inet;

	static char dgram[2000]; /* recieve buffer */
	static char dgramR[2000]; /* recieve buffer */
	char tmpbuf[100];
	char *kill;

	fd_set rfds;
	struct timeval tv;

	fail = false;

	memset(&adr_srv,0,sizeof adr_srv);
	adr_srv.sin_family = AF_INET;
	adr_srv.sin_port = htons(serv[cur_serv].logmodport);
	adr_srv.sin_addr.s_addr = inet_addr(serv[cur_serv].cs_server_addr);

	if( adr_srv.sin_addr.s_addr == INADDR_NONE ) {
		perror("Bad Address");
		return -1;
	}

	len_inet = sizeof adr_srv;

	/*
		Create UDP socket to use 
	*/

	s = socket(AF_INET,SOCK_DGRAM,0);
	if(s == -1)
		return -2;

	signal(SIGINT, signal_handler_vlog);
		
	snprintf(dgram, sizeof dgram, "\xff\xff\xff\xffLogMod: Key %s",serv[cur_serv].logmodkey);

	z = sendto(s, dgram, strlen(dgram),0, (struct sockaddr *)&adr_srv, len_inet);
	if((z < 0 ) || (fail)) {
		printf("sendto error\n");	
		return -3;
	}

	x = sizeof adr;

	FD_ZERO(&rfds);
	FD_SET(s,&rfds);
	tv.tv_sec = 2;  // Set timeout
	tv.tv_usec =  100000;

	retval = select(s+1,&rfds,NULL,NULL,&tv);
	if(retval) {	
		z = recvfrom(s, dgramR, sizeof(dgramR), 0, (struct sockaddr *)&adr, &x);
		if((z < 0 ) || (fail))  {
			return -4;
		}
	}
	else 
		return -5;
		
	printf("%s\n",dgramR+4);	

	memset (dgram, '\0', sizeof(dgram));	
	snprintf(dgram, sizeof(dgram), "\xff\xff\xff\xffLogMod: Heartbeat");

	for(;;) {

		memset (dgramR, '\0', sizeof(dgramR));	

		z = recvfrom(s, dgramR, sizeof(dgramR), 0, (struct sockaddr *)&adr, &x);
		if((z < 0 ) || (fail))
			return -1;
	
		if(strstr(dgramR,"Heartbeat")) {
			z = sendto(s, dgram, strlen(dgram),0, (struct sockaddr *)&adr_srv, len_inet);
			//printf("%s\n",dgramR);	
		}
		else {
			if(color) {
				if((kill = strstr(dgramR,"killed"))) {
					memset(tmpbuf,'\0',sizeof(tmpbuf));
					strlcpy(tmpbuf,kill,sizeof(tmpbuf));
					*kill = '\0';
					if(strstr(dgramR,"<CT>")) {
						printf("\e[%sm%s\e[0m",vlogcolor.cs_ctcolor, dgramR+4);	
						printf("\e[%sm%s\e[0m",vlogcolor.cs_ctcolor, tmpbuf);	
					}
					else if(strstr(dgramR,"<TERRORIST>")) {
						printf("\e[%sm%s\e[0m",vlogcolor.cs_tcolor, dgramR+4);	
						printf("\e[%sm%s\e[0m",vlogcolor.cs_tcolor, tmpbuf);	
					}
				
				}
				else if(strstr(dgramR,"say "))
					printf("\e[%sm%s\e[0m",vlogcolor.cs_say, dgramR+4);	
				else if(strstr(dgramR,"<CT>"))
					printf("\e[%sm%s\e[0m",vlogcolor.cs_ctcolor, dgramR+4);	
				else if(strstr(dgramR,"<TERRORIST>"))
					printf("\e[%sm%s\e[0m",vlogcolor.cs_tcolor, dgramR+4);	
				else if(strstr(dgramR,"banid"))
					printf("\e[%sm%s\e[0m",vlogcolor.cs_bankick, dgramR+4);	
				else if(strstr(dgramR,"Kick:"))
					printf("\e[%sm%s\e[0m",vlogcolor.cs_bankick,dgramR+4);	
				else if(strstr(dgramR,"rcon"))
					printf("\e[%sm%s\e[0m",vlogcolor.cs_rcon, dgramR+4);	
				else 
					printf("%s",dgramR+4);	
			}
			else {
				printf("%s",dgramR+4);	
			}
		}
		fflush(stdout);

	}
		
	close(s);
}


