/* 
 * Copyright (C) 2003  Sam Vaughan <yamaneko@centurytel.net>
 *
 * File: wmain.c
 * This file is part of Vrcon
 *
 * Vrcon
 * VaughanTech's  remote control for Cstrike and other Half-Life MODS
 * (rcon from a terminal)
 * 
 * Written by Sam "Jack Bauer" Vaughan
 *
 *
 * Licensed under the GNU General Public License
 *
 * Vrcon is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * Vrcon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Vrcon; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
*/

#include "sv.h"
#include "rcon.h"
#include "moh.h"
#include "bf1942.h"
#include "ut2k4.h"
#include "quake3.h"
//#include "doom3.h"
#include "source.h"
#include "config.h"

static char **c_menu = '\0';
static int selected_row = 0;

player csp[MAX_PLAYERS];
cstrike csrv;

extern char config_path[MAX_STRING];
extern servers serv[];
extern int cur_serv;

extern bf_player bfp[];
extern int cur_bfp;

extern ea_server_info bfsi;
extern ut2k4_server_info ut2si;

extern q3_player q3p[];
extern int cur_q3p;

extern q3_server_info q3si;

extern source_player sourcep[];
extern int cur_sourcep;

extern source_server_info sourcesi;

extern char *adminWONIDS[MAX_ADMINS];
extern int  TOTAL_ADMINS;

extern char *flagWONIDS[MAX_ADMINS];
extern int  TOTAL_FLAG;

extern char *flagIP[MAX_ADMINS];
extern int  TOTAL_IP;

char *topgreet = " Vrcon "; 
char *start_menu[] = 
{
	"sConnect",
	"iServer",
	"qQuit",
	0,
};

extern char *moh_menu[];
extern char *bf_menu[];
extern char *ut2_menu[]; 
extern char *q3_menu[]; 
extern char *cod_menu[]; 
extern char *source_menu[]; 

char *main_menu[] = 
{
	"sRefresh",
	"arcon",
	"mChange Map",
	"iServer",
#ifdef CM_SAY
	"tcm_say",
#endif
#ifdef AMX_SAY
	"Tamx_say",
#endif
	"jKick",
	"kBan 1 Min",
	"lBan 30 Min",
	"bBan Perm",
//	"cScreenShots",         DO WE REALLY NEED ANYMORE?
	"qQuit",
	0,
};

int getchoice(char *greet, char *choices[])
{

	//static int selected_row = 0;
	int max_row = 0;
	int start_screenrow = MESSAGE_LINE, start_screencol = 0;
	char **option;
	int selected;
	int key = 0;
	
	option = choices;

	while(*option) {
		max_row++;
		option++;
	}

	if(selected_row >= max_row)
		selected_row = 0;
	
	mvprintw(start_screenrow, start_screencol, "%s" ,greet);
	
	keypad(stdscr, TRUE);
	cbreak();
	noecho();

	key = 0;
	while(key != 'q' && key != KEY_ENTER && key != '\n' && key != 27) {
		if(key == KEY_UP) {
			if(selected_row == 0)
				selected_row = max_row -1;
			else
				selected_row--;
		}
		if(key == KEY_DOWN) {
			if(selected_row == (max_row -1))
				selected_row = 0;
			else
				selected_row++;
		}

		selected = *choices[selected_row];
		draw_menu(choices, selected_row, start_screenrow, start_screencol);

		key = getch();
	}
	
	keypad(stdscr, FALSE);
	nocbreak();
	echo();
	
	if(key == 'q')
		selected = 'q';
	if(key == 27) {
		selected = 'E';
	}

	return(selected);
}

void draw_menu(char *options[], int current_highlight, int start_row, int start_col)
{

	int current_row = 0;
	char **option_ptr;
	char *txt_ptr;


	option_ptr = options;
	while(*option_ptr) {
		if(current_row == current_highlight) {
			attron(A_REVERSE);
		} 
		else {
			attroff(A_REVERSE);
		}
		
		txt_ptr = options[current_row];
		txt_ptr++;
		mvprintw(start_row +2 + current_row, start_col, "%s", txt_ptr);
		current_row++;
		option_ptr++;
	}

	attroff(A_REVERSE);

	refresh();
}
	
		
		
void clear_all_screen(void)
{
	clear();
}


void get_string(char *string)
{
	int len;
	int mx;
	int my;
	
	getmaxyx(stdscr,my,mx);

	mvprintw(my -1,1, "Enter command or q to quit");
	mvprintw(my -2,1, "vrcon> ");
	mvwgetnstr(stdscr,my -2 ,7, string, MAX_STRING);
	len = strlen(string);
	if(len > 0 && string[len -1] == '\n')
		string[len -1] = '\0';
}

int get_confirm(char *message)
{
	int confirmed = 0;
	char first_char;
	
	mvprintw(Q_LINE, 5, "%s", message);
	mvprintw(Q_LINE+1, 6, " Hit ENTER for Yes ");
	clrtoeol();
	refresh();

	cbreak();
	first_char = getch();
	if(first_char == '\n' ) {
		confirmed = 1;
	}
	nocbreak();

	if(!confirmed) {
		mvprintw(Q_LINE, 1, "	Cancelled");
		clrtoeol();
		refresh();
		sleep(1);
		mvprintw(Q_LINE, 1, "	         ");
		mvprintw(Q_LINE+1, 6, "                                   ");
	}

	return(confirmed);

}

int s_rcon_command(char *command)
{
	int lines_op = 0;
	char *info = NULL;

	clear_all_screen();

	if(strstr(serv[cur_serv].game,"hlife")) {
		info = send_hlife_rcon(command);
	}
	else if (strstr(serv[cur_serv].game,"moh")) {
		info = send_moh_rcon(command);
	}
	else if (strstr(serv[cur_serv].game,"source")) {
		info = send_source_rcon(command);
	}
	else if (strstr(serv[cur_serv].game,"cod")) {
		info = send_q3_rcon(command);
	}
	else if (strstr(serv[cur_serv].game,"quake3")) {
		info = send_q3_rcon(command);
	}
	else {
		info=NULL;
	}

	if(info) {
		lines_op = 10;
		mvprintw(lines_op, 0, "%s\n--", info);

		wrefresh(stdscr);
		nocbreak();
		echo();	
		return 0;
	}
	else {
		return -1;
	}

}

/* 
 *rcon_command
 * send rcon command based on game type
 */ 
int rcon_command()
{
	int lines_op = 0;
	char *info = NULL;
	char command[100];

	memset(command,'\0',sizeof(command));
	get_string(command);
	clear_all_screen();
	if(strcmp(command,"q") == 0) {
		return 1;
	}
	if(strstr(serv[cur_serv].game,"hlife")) {
		info = send_hlife_rcon(command);
	}
	else if (strstr(serv[cur_serv].game,"moh")) {
		info = send_moh_rcon(command);
	}
	else if (strstr(serv[cur_serv].game,"source")) {
		info = send_source_rcon(command);
	}
	else if (strstr(serv[cur_serv].game,"cod")) {
		info = send_q3_rcon(command);
	}
	else if (strstr(serv[cur_serv].game,"quake3")) {
		info = send_q3_rcon(command);
	}
	else {
		info=NULL;
	}	

	if(info) {
		lines_op = 12;
		mvprintw(lines_op, 0, "%s\n--", info);

		wrefresh(stdscr);
		nocbreak();
		echo();	

		return 0;
	}
	else {
		return -1;
	}

}

/* CmSayCommand
   type is 0 for clanmod or 1 for amx
*/
int CmSayCommand(int type)
{
        int lines_op = 0;
        char *info = NULL; 
        char command[100];
        char text[80];

        memset(command,'\0',sizeof(command));
        memset(text,'\0',sizeof(text));
        get_string(text);
        clear_all_screen();
        if(strcmp(text,"q") == 0) { 
                return 1;
        }       

	if(type == 0)
		snprintf(command, sizeof(command), "%s %s \"%s\"", "cm_say", cmsay_color ,text) ;
	else if(type == 1)
		snprintf(command, sizeof(command), "%s %s %s", "amx_csay", amxsay_color ,text) ;

        info = send_hlife_rcon(command);       
        if(info) {
                lines_op = 12;
                mvprintw(lines_op, 0, "%s\n--", info);
                mvprintw(lines_op, 2, "%s\n--", command);

                wrefresh(stdscr);
                nocbreak();
                echo(); 
        }       
        return 0;
}


int list_status()
{
	int i;
	int lines_op = 0;
	int al_line = 0;
	int ax_line = 0;
	int mx;
	int my;
	char *info = NULL;
	char *hdr;
	char *command = "status"; 

	getmaxyx(stdscr,my,mx);
	// Add code to see the max xy is greater than 80x25, 
	// if so, expand the realestate
	
	mvprintw(my -2, 1, "Connecting to: " );
	mvprintw(my -2, 16, serv[cur_serv].name );
	mvprintw(my -1, 1, "Type Control-C  to cancel  " );
	wrefresh(stdscr);

	clear_sap();
	if(strcmp(serv[cur_serv].game,"hlife") == 0) {	
		info = send_hlife_rcon(command);	
		c_menu = main_menu;
	}
	else if(strcmp(serv[cur_serv].game,"bf1942") == 0) {
		info = get_status("\\status\\"); 
		c_menu = bf_menu;
	}
	else if(strcmp(serv[cur_serv].game,"moh") == 0) {
		info = get_status("\\status\\"); 
		c_menu = moh_menu;
	}
	else if(strcmp(serv[cur_serv].game,"cod") == 0) {
		info = get_status("\xff\xff\xff\xffgetstatus"); 
		c_menu = cod_menu;
	}
	else if(strcmp(serv[cur_serv].game,"quake3") == 0) {
		info = get_status("\xff\xff\xff\xffgetstatus"); 
		c_menu = q3_menu;
	}
	else if(strcmp(serv[cur_serv].game,"ut2k4") == 0) {
		info = get_status("\\status\\"); 
		c_menu = ut2_menu;
	}
	else if(strcmp(serv[cur_serv].game,"source") == 0) {
		info = get_source_status(); 
		c_menu = source_menu;
	}


	if(info == NULL) {
		mvprintw(my -2, 1, "                                               " );
		mvprintw(my -1, 1, "                                            " );
		wrefresh(stdscr);
		mvprintw(2, 15, " Connect to " );
		mvprintw(2, 27, serv[cur_serv].name );
		mvprintw(2, 28 + strlen(serv[cur_serv].name), "timed out." );
		mvprintw(4, 15, " Use Connect to retry or select another server" );
		c_menu = start_menu;
		return -1;
	}
		
	clear_all_screen();
	wrefresh(stdscr);

	lines_op = 3;

	//mvprintw(lines_op, 0, "%s\n--", hdr);

	if(strcmp(serv[cur_serv].game,"hlife") == 0) {	
		hdr = p_dgram(info);

		mvprintw(0,12,"Name ");
		attron(A_REVERSE);
		mvprintw(0, 18, "%s  ", csrv.hostname);
		attroff(A_REVERSE);

		mvprintw(1,12,"Map  ");
		attron(A_REVERSE);
		mvprintw(1, 17, "%s ", csrv.map);
		attroff(A_REVERSE);

		mvprintw(1,19+strlen(csrv.map),"Players ");
		attron(A_REVERSE);
		mvprintw(1,27+strlen(csrv.map), "%s  ", csrv.players);
		attroff(A_REVERSE);
		
		attron(A_REVERSE);
		mvprintw(lines_op,13, "Name                 ");
		mvprintw(lines_op,35, "STEAMID / WONID  ");
		mvprintw(lines_op,53, "FRAGS");
		// Need to make room for 1.6
		//mvprintw(lines_op,52, "TIME  ");
		mvprintw(lines_op,59, "PING");
		mvprintw(lines_op++,64, "IP             ");
		attroff(A_REVERSE);

		for(i=0;i<MAX_PLAYERS;i++) {
			if(csp[i].set)
			    mvprintw(lines_op,13, "%.*s",21, csp[i].name);
			    mvprintw(lines_op,35, "%s", csp[i].wonid);
			    mvprintw(lines_op,53, " %s", csp[i].frags);
			    // Need to make room for 1.6
			    //mvprintw(lines_op,52, "%s", csp[i].time);
			    mvprintw(lines_op,59, "%s", csp[i].ping);
			    mvprintw(lines_op++,64, "%s", csp[i].ip);
		}

	}
	else if(strcmp(serv[cur_serv].game,"source") == 0) {	
		proc_source_dgram(info);	// Proc server info
		info = get_source_players();  // Stat Players
		proc_source_dgram(info);	// Proc players
		info  = send_source_rcon("status");// Get the rest of the info we need
		proc_source_players(info);

		mvprintw(0,12,"Name ");
		attron(A_REVERSE);
		mvprintw(0, 18, "%s", sourcesi.hostname);
		attroff(A_REVERSE);

		mvprintw(1,12,"Map  ");
		attron(A_REVERSE);
		mvprintw(1, 17, "%s", sourcesi.map);
		attroff(A_REVERSE);

		mvprintw(1,19+strlen(sourcesi.map),"Players ");
		attron(A_REVERSE);
		mvprintw(1, 27+strlen(sourcesi.map), "%s/%s", sourcesi.players,sourcesi.max_players);
		attroff(A_REVERSE);
		
		attron(A_REVERSE);
		mvprintw(lines_op,13, "Name                 ");
		mvprintw(lines_op,35, "STEAMID / WONID  ");
		mvprintw(lines_op,53, "FRAGS");
		// Need to make room for 1.6
		//mvprintw(lines_op,52, "TIME  ");
		//mvprintw(lines_op,59, "PING");
		mvprintw(lines_op++,59, "IP              ");
		attroff(A_REVERSE);

		for(i=0;i<MAX_SOURCE_PLAYERS;i++) {
			if(sourcep[i].set)
			    mvprintw(lines_op,13, "%.*s",21, sourcep[i].name);
			    mvprintw(lines_op,35, "%s", sourcep[i].wonid);
			    mvprintw(lines_op,53, " %s", sourcep[i].frags);
			    // Need to make room for 1.6
			    //mvprintw(lines_op,52, "%s", sourcep[i].time);
			    //mvprintw(lines_op,59, "%s", sourcep[i].ping);
			    mvprintw(lines_op++,59, "%s", sourcep[i].ip);
		}


	}
	else if((strcmp(serv[cur_serv].game,"quake3") == 0) || (strcmp(serv[cur_serv].game,"cod") == 0)) {
		proc_q3_dgram(info);

		mvprintw(0,12,"Name ");
		attron(A_REVERSE);
		mvprintw(0,17,"%s",q3si.hostname);
		attroff(A_REVERSE);

		mvprintw(0,strlen(q3si.hostname)+19,"Ver ");
		attron(A_REVERSE);
		mvprintw(0,strlen(q3si.hostname)+23,"%s",q3si.version);
		attroff(A_REVERSE);

		mvprintw(1,12,"Players ");
		attron(A_REVERSE);
		mvprintw(1,20,"%s/%s",q3si.numplayers,q3si.maxplayers);
		attroff(A_REVERSE);

		mvprintw(1,26,"Map ");
		attron(A_REVERSE);
		mvprintw(1,30,"%s",q3si.mapname);
		attroff(A_REVERSE);

		mvprintw(1,25+(strlen(q3si.mapname)+6),"Punkbuster ");
		attron(A_REVERSE);
		mvprintw(1, 25+(strlen(q3si.mapname)+17) ,"%s",q3si.punkbuster);
		attroff(A_REVERSE);

		mvprintw(1,25+(strlen(q3si.mapname)+21),"GameType ");
		attron(A_REVERSE);
		mvprintw(1, 25+(strlen(q3si.mapname)+30) ,"%s",q3si.gametype);
		attroff(A_REVERSE);

		ax_line = 4;	
		al_line = 4;
		mvprintw(3,19,"PLAYER");
		attron(A_REVERSE);
		mvprintw(3,36,"K  ");
		mvprintw(3,40,"P  ");
		attroff(A_REVERSE);
		mvprintw(3,49,"PLAYER");
		attron(A_REVERSE);
		mvprintw(3,70,"K  ");
		mvprintw(3,74,"P  ");
		attroff(A_REVERSE);

		for(i=0;i<MAX_Q3PLAYERS;i++) {
			if(q3p[i].set == true) {
				if(i < 20) {
				    mvprintw(ax_line,11, "%.*s",24, q3p[i].name);
				    mvprintw(ax_line,36, "%s", q3p[i].score);
				    mvprintw(ax_line++,40, "%s", q3p[i].ping);
				}
			    	else if(i >= 20) {
				    mvprintw(al_line,45, "%.*s",24, q3p[i].name);
				    mvprintw(al_line,70, "%s", q3p[i].score);
				    mvprintw(al_line++,74, "%s", q3p[i].ping);
				}
			}
		}


	}
	else if(strcmp(serv[cur_serv].game,"bf1942") == 0) {
		proc_bf_dgram(info);
				
		mvprintw(0,12,"Name ");
		attron(A_REVERSE);
		mvprintw(0,17,"%s",bfsi.hostname);
		attroff(A_REVERSE);

		mvprintw(0,strlen(bfsi.hostname)+19,"Ver ");
		attron(A_REVERSE);
		mvprintw(0,strlen(bfsi.hostname)+23,"%s",bfsi.version);
		attroff(A_REVERSE);

		mvprintw(1,12,"Players ");
		attron(A_REVERSE);
		mvprintw(1,20,"%s/%s",bfsi.numplayers,bfsi.maxplayers);
		attroff(A_REVERSE);

		mvprintw(1,26,"Map ");
		attron(A_REVERSE);
		mvprintw(1,30,"%s",bfsi.mapname);
		attroff(A_REVERSE);

		mvprintw(1,31 + strlen(bfsi.mapname),"FF ");
		attron(A_REVERSE);
		mvprintw(1,34+ strlen(bfsi.mapname),"%s",bfsi.SoldierFF);
		attroff(A_REVERSE);

		mvprintw(1,39 + strlen(bfsi.mapname),"VFF ");
		attron(A_REVERSE);
		mvprintw(1,43+ strlen(bfsi.mapname),"%s",bfsi.VehicleFF);
		attroff(A_REVERSE);

		mvprintw(0,strlen(bfsi.hostname)+29,"Type ");
		attron(A_REVERSE);
		mvprintw(0,strlen(bfsi.hostname)+34,"%s",bfsi.gametype);
		attroff(A_REVERSE);
/*  Save some space
		mvprintw(0,strlen(bfsi.hostname)+strlen(bfsi.gametype)+35,"Port ");
		attron(A_REVERSE);
		mvprintw(0,strlen(bfsi.hostname)+strlen(bfsi.gametype)+40,bfsi.hostport);
		attroff(A_REVERSE);
*/
	
		ax_line = 4;	
		al_line = 4;
		mvprintw(3,19,"AXIS");
		attron(A_REVERSE);
		mvprintw(3,32,"S ");
		mvprintw(3,35,"K ");
		mvprintw(3,38,"D ");
		mvprintw(3,41,"P  ");
		attroff(A_REVERSE);
		mvprintw(3,49,"ALLIED");
		attron(A_REVERSE);
		mvprintw(3,66,"S  ");
		mvprintw(3,70,"K ");
		mvprintw(3,73,"D ");
		mvprintw(3,76,"P  ");
		attroff(A_REVERSE);
		for(i=0;i<MAX_BFPLAYERS;i++) {
			if(bfp[i].set == true) {
				if(atoi(bfp[i].team) == 1) {
				    mvprintw(ax_line,11, "%.*s",20, bfp[i].name);
				    mvprintw(ax_line,32, "%s", bfp[i].score);
				    mvprintw(ax_line,35, "%s", bfp[i].frags);
				    mvprintw(ax_line,38, "%s", bfp[i].deaths);
				    mvprintw(ax_line++,41, "%s", bfp[i].ping);
				}
			    	else if(atoi(bfp[i].team) == 2) {
				    mvprintw(al_line,45, "%.*s",20, bfp[i].name);
				    mvprintw(al_line,66, "%s", bfp[i].score);
				    mvprintw(al_line,70, "%s", bfp[i].frags);
				    mvprintw(al_line,73, "%s", bfp[i].deaths);
				    mvprintw(al_line++,76, "%s", bfp[i].ping);
				}
			}
		}
	}
	else if(strcmp(serv[cur_serv].game,"ut2k4") == 0) {

		proc_ut2_dgram(info);
		

		mvprintw(0,12,"Name ");
		attron(A_REVERSE);
		mvprintw(0,17,"%s",ut2si.hostname);
		attroff(A_REVERSE);

		mvprintw(0,strlen(ut2si.hostname)+19,"Ver ");
		attron(A_REVERSE);
		mvprintw(0,strlen(ut2si.hostname)+23,"%s",ut2si.version);
		attroff(A_REVERSE);

		mvprintw(1,12,"Players ");
		attron(A_REVERSE);
		mvprintw(1,20,"%s/%s",ut2si.num_players,ut2si.max_players);
		attroff(A_REVERSE);

		mvprintw(1,26,"Map ");
		attron(A_REVERSE);
		mvprintw(1,30,"%s",ut2si.map);
		attroff(A_REVERSE);

		mvprintw(0,strlen(ut2si.hostname)+29,"Type ");
		attron(A_REVERSE);
		mvprintw(0,strlen(ut2si.hostname)+35,"%s",ut2si.game_type);
		attroff(A_REVERSE);

		mvprintw(1,strlen(ut2si.map)+31,"Port ");
		attron(A_REVERSE);
		mvprintw(1,strlen(ut2si.map)+36,"%s",ut2si.port);
		attroff(A_REVERSE);
	
		ax_line = 4;	
		al_line = 4;
		mvprintw(3,19,"PLAYER");
		attron(A_REVERSE);
		mvprintw(3,32,"K   ");
		mvprintw(3,37,"P    ");
		attroff(A_REVERSE);
		mvprintw(3,49,"PLAYER");
		attron(A_REVERSE);
		mvprintw(3,66,"K   ");
		mvprintw(3,71,"P    ");
		attroff(A_REVERSE);

		for(i=0;i<MAX_UTPLAYERS;i++) {
			if(utp[i].set == true) {
				if(i < 20) {
				    mvprintw(ax_line,11, "%.*s",20, utp[i].name);
				    mvprintw(ax_line,32, "%s", utp[i].frags);
				    mvprintw(ax_line++,37, "%s", utp[i].ping);
				}
			    	else if(i >= 20) {
				    mvprintw(al_line,45, "%.*s",20, utp[i].name);
				    mvprintw(al_line,66, "%s", utp[i].frags);
				    mvprintw(al_line++,71, "%s", utp[i].ping);
				}
			}
		}
	}
	else if(strcmp(serv[cur_serv].game,"moh") == 0) {

		proc_moh_dgram(info);

		mvprintw(0,12,"Name ");
		attron(A_REVERSE);
		mvprintw(0,17,"%s",bfsi.hostname);
		attroff(A_REVERSE);

		mvprintw(0,strlen(bfsi.hostname)+19,"Ver ");
		attron(A_REVERSE);
		mvprintw(0,strlen(bfsi.hostname)+23,"%s",bfsi.gamever);
		attroff(A_REVERSE);

		mvprintw(1,12,"Players ");
		attron(A_REVERSE);
		mvprintw(1,20,"%s/%s",bfsi.numplayers,bfsi.maxplayers);
		attroff(A_REVERSE);

		mvprintw(1,26,"Map ");
		attron(A_REVERSE);
		mvprintw(1,30,"%s",bfsi.mapname);
		attroff(A_REVERSE);

		mvprintw(0,strlen(bfsi.hostname)+29,"Type ");
		attron(A_REVERSE);
		mvprintw(0,strlen(bfsi.hostname)+35,"%s",bfsi.gametype);
		attroff(A_REVERSE);

		mvprintw(1,strlen(bfsi.mapname)+31,"Port ");
		attron(A_REVERSE);
		mvprintw(1,strlen(bfsi.mapname)+36,"%s",bfsi.hostport);
		attroff(A_REVERSE);
	
		ax_line = 4;	
		al_line = 4;
		mvprintw(3,19,"PLAYER");
		attron(A_REVERSE);
		mvprintw(3,32,"K  ");
		mvprintw(3,36,"D  ");
		mvprintw(3,40,"P  ");
		attroff(A_REVERSE);
		mvprintw(3,49,"PLAYER");
		attron(A_REVERSE);
		mvprintw(3,66,"K  ");
		mvprintw(3,70,"D  ");
		mvprintw(3,74,"P  ");
		attroff(A_REVERSE);
		for(i=0;i<MAX_BFPLAYERS;i++) {
			if(bfp[i].set == true) {
				if(i < 20) {
				    mvprintw(ax_line,11, "%.*s",20, bfp[i].name);
				    mvprintw(ax_line,32, "%s", bfp[i].frags);
				    mvprintw(ax_line,36, "%s", bfp[i].deaths);
				    mvprintw(ax_line++,40, "%s", bfp[i].ping);
				}
			    	else if(i >= 20) {
				    mvprintw(al_line,45, "%.*s",20, bfp[i].name);
				    mvprintw(al_line,66, "%s", bfp[i].frags);
				    mvprintw(al_line,70, "%s", bfp[i].deaths);
				    mvprintw(al_line++,74, "%s", bfp[i].ping);
				}
			}
		}
	}
	

	wrefresh(stdscr);
	nocbreak();
	echo();	

	return 0;


}

char *  vcon_mbox(void)
{

	int ii;
	int xx;
	int i =0;
	int j;
	int key = 0;
	int max_rows = 16;
	int max_item = 0;
	int top_view_row = 0;
	int sel_index = 0;
	char *mapbuf = NULL;
	char *p;
	char *mp;
	char *dot;
	static char maps[MAX_MAPS][MAX_MAP_NAME];
	char buf[MAX_RETBUF +1];
	char tbuf[250];

	WINDOW *mbox;


	for(i=0;i<MAX_MAPS;i++) {
		memset(maps[i], '\0', MAX_MAP_NAME) ;
	}

	mbox = newwin(max_rows +2,30,3,15);
	box(mbox,'|','-');
	keypad(mbox,TRUE);
	cbreak();
	noecho();

	mvwprintw(mbox,0,2, " [ Select Map      ] ");

	if(strstr(serv[cur_serv].game,"hlife")) {
		mapbuf = send_hlife_rcon("maps *");	
		memset(buf,'\0',sizeof(buf));
		memset(tbuf,'\0',sizeof(tbuf));
		strlcpy(buf,mapbuf,sizeof(buf));

		i=0;
		for(ii=0,xx=0;ii<strlen(buf);ii++,xx++) {
			if(buf[ii] == '\n') {

				if(strstr(tbuf,"valve") && strstr(tbuf,"Dir:")) {
					// We want to stop getting map names
					break;
				}
			
				// clean up name here
				if(strchr(tbuf,'/')) {
					p = strrchr(tbuf,'/');	
				}	
				else {	
					p = strchr(tbuf,' ');
				}

				if((dot = strchr(tbuf,'.')))
					*dot = '\0';

				// fix for hlds output version 4111(a) and 3111(a) 
				if(p) {
					if(strstr(tbuf,"(fs)")) {
						strlcpy(maps[i++],p+1 , sizeof(maps[i]));
					}
				}
				else {
					if(dot)
						strlcpy(maps[i++],tbuf , sizeof(maps[i]));
				}
				
				memset(tbuf,'\0',sizeof(tbuf));
				xx=-1;
			}
			else
				tbuf[xx] = buf[ii];
		}

	}
	else if(strcmp(serv[cur_serv].game,"source") == 0){
		mapbuf = send_source_rcon("maps *");
		memset(buf,'\0',sizeof(buf));
		memset(tbuf,'\0',sizeof(tbuf));
		strlcpy(buf,mapbuf,sizeof(buf));

		i=0;
		for(ii=0,xx=0;ii<strlen(buf);ii++,xx++) {
			if(buf[ii] == '\n') {

				if(strstr(tbuf,".bsp")) {
					if((dot = strchr(tbuf,'.')))
						*dot = '\0';
	
					// Who knows this may change....	
					mp = strstr(tbuf,"(fs)");		
					
					strlcpy(maps[i++],mp+5 , sizeof(maps[i]));
				}
				
				memset(tbuf,'\0',sizeof(tbuf));
				xx=-1;
			}
			else
				tbuf[xx] = buf[ii];
		}

	}
	else if(strcmp(serv[cur_serv].game,"quake3") == 0){
		mapbuf = send_q3_rcon("dir maps bsp");
		memset(buf,'\0',sizeof(buf));
		memset(tbuf,'\0',sizeof(tbuf));
		strlcpy(buf,mapbuf,sizeof(buf));

		i=0;
		for(ii=0,xx=0;ii<strlen(buf);ii++,xx++) {
			if(buf[ii] == '\n') {

				if(strstr(tbuf,".bsp")) {
					if((dot = strchr(tbuf,'.')))
						*dot = '\0';

					strlcpy(maps[i++],tbuf , sizeof(maps[i]));
				}
				
				memset(tbuf,'\0',sizeof(tbuf));
				xx=-1;
			}
			else
				tbuf[xx] = buf[ii];
		}

	}
	else if (strstr(serv[cur_serv].game,"moh")) {
		mapbuf = send_moh_rcon("sv_maplist");

		i=0;
		memset(buf,'\0',sizeof(buf));
		memset(tbuf,'\0',sizeof(tbuf));
		mp = strchr(mapbuf,':');
		mp++;mp++;
		while(*mp != '"') {
			buf[i++] = *mp;
			mp++;
		}

		i=0;
		p = buf;
		while((mp = strchr(p,' '))) {
			*mp = '\0';
			strlcpy(maps[i],p , sizeof(maps[i]));
			i++;mp++;
			p = mp;
		}
	}
	else if (strstr(serv[cur_serv].game,"cod")) {
		mapbuf = send_q3_rcon("sv_mapRotation");

		i=0;
		memset(buf,'\0',sizeof(buf));
		memset(tbuf,'\0',sizeof(tbuf));
		mp = strchr(mapbuf,':');
		mp++;mp++;
		while(*mp != '"') {
			buf[i++] = *mp;
			mp++;
		}

		i=0;
		p = buf;
		while((mp = strchr(p,' ')) || (mp = strchr(p,'^'))) {
			*mp = '\0';

			// Don't do it this way, grab anything except 
			// gametype, map tdm 
			if((strstr(p,"map")) || 
			   (strstr(p,"dm")) || 
			   (strstr(p,"bel")) || 
			   (strstr(p,"re")) || 
			   (strstr(p,"sd")) || 
			   (strstr(p,"hq")) || 
			   (strstr(p,"tdm")) || 
			   (strstr(p,"gametype"))   )  {
				// We want to ignore these
			}
			else {
			//if(strstr(p,"mp_"))  {
				strlcpy(maps[i],p , sizeof(maps[i]));
				i++;
			}
			mp++;
			p = mp;
		}
	}

	else {
		mapbuf = NULL;
	}

	if(mapbuf == NULL) {
		return NULL;
	}

	// get max entries
	for(i=0;i<MAX_MAPS;i++) {
		if(maps[i][0] != '\0')
			max_item++;	
	}
	max_item--;
	
	// only draw the up to the max_rows
	for(i=0;i<(max_rows );i++) {
		if(i == sel_index) {
			wattron(mbox,A_REVERSE);
		}
		else {
			wattroff(mbox,A_REVERSE);
		}

		mvwprintw(mbox,i+1,1, " %s", maps[i]);
	}

	wattroff(mbox,A_REVERSE);
	wrefresh(mbox);

	key = 0;
	while(key != 'q' && key != KEY_ENTER && key != '\n') {

		key = getch();

		if(key == 65) { //UP
			if(sel_index == top_view_row) {
				if(sel_index == 0) {
					sel_index = 0;
				} 
				else {
					top_view_row--;
					sel_index--;
				}
			}	
			else
				sel_index--; 
		}
		if(key == 66) { //DOWN
			if(sel_index == (top_view_row + max_rows -1 )) {
				if(sel_index == max_item)
					sel_index = sel_index;
				else {
					top_view_row++;
					sel_index++;
				}
			}	
			else {
				if(sel_index != max_item) 
					sel_index++;
			}
		}

		if((key == 32) || (key == 110)) { // n or SPACE BAR - (PAGE DOWN)

			if((top_view_row + max_rows) > (max_item - (max_rows -1)) ) {

				if (max_item <= max_rows ) {
					top_view_row = 0;
					sel_index = max_item;
				}
				else {
					top_view_row = (max_item - (max_rows -1));
					sel_index = top_view_row;
				}

			}	
			else {
				top_view_row = (top_view_row + max_rows);
				sel_index = top_view_row;
			}
		}

		if(key == 112) { //p - (Previous - PAGE up)

			if((top_view_row - max_rows ) < 0) {
				top_view_row = 0;
				sel_index = top_view_row;
			}	
			else {
				top_view_row = (top_view_row - max_rows);
				sel_index = top_view_row;
			}
		}

		if(key == 116) { //t - TOP  jump to the top of the list

			top_view_row = 0;
			sel_index = top_view_row;
		}

		if(key == 98) { //b - BOTTOM  jump to the BOTTOM of the list

			if (max_item <= max_rows ) {
				top_view_row = 0;
				sel_index = max_item;
			}
			else {
				top_view_row = (max_item - (max_rows -1));
				sel_index = top_view_row;
			}

		}

		j = top_view_row;;
		for(i=0;i<max_rows ;i++,j++) {
			if(j == sel_index) {
				wattron(mbox,A_REVERSE);
			}
			else {
				wattroff(mbox,A_REVERSE);
			}

			mvwprintw(mbox,i+1,1, "                            ");
			mvwprintw(mbox,i+1,1, " %s", maps[j]);
		}

		wattroff(mbox,A_REVERSE);
		wrefresh(mbox);
	}

	if(key == 'q') 
		return NULL;

	keypad(mbox, FALSE);
	nocbreak();
	echo();
	clear();
	delwin(mbox);
	wrefresh(stdscr);
	return(maps[sel_index]);

}


int vcon_sbox(void)
{

	int i =0;
	int j;
	int key = 0;
	int max_rows = 16;
	int max_item = 0;
	int top_view_row = 0;
	int sel_index = 0;
	WINDOW *sbox;

	
	sbox = newwin(max_rows +2,30,4,15);
	box(sbox,'|','-');
	keypad(sbox,TRUE);
	cbreak();
	noecho();
	
	for(i=0;i<MAX_SERV;i++) {
		if(serv[i].set)
			max_item++;	
	}
	max_item--;

	// only draw the up to the max_rows
	for(i=0;i<(max_rows );i++) {
		if(i == sel_index) {
			wattron(sbox,A_REVERSE);
		}
		else {
			wattroff(sbox,A_REVERSE);
		}

		mvwprintw(sbox,i+1,1, " %s", serv[i].name);
	}

	wattroff(sbox,A_REVERSE);
	wrefresh(sbox);

	key = 0;
	while(key != 'q' && key != KEY_ENTER && key != '\n') {

		key = getch();
		if(key == 65) { //UP
			if(sel_index == top_view_row) {
				if(sel_index == 0) {
					sel_index = 0;
				} 
				else {
					top_view_row--;
					sel_index--;
				}
			}	
			else
				sel_index--; 
		}
		if(key == 66) { //DOWN
			if(sel_index == (top_view_row + max_rows -1 )) {
				if(sel_index == max_item)
					sel_index = sel_index;
				else {
					top_view_row++;
					sel_index++;
				}
			}	
			else {
				if(sel_index != max_item) 
					sel_index++;
			}
		}


		j = top_view_row;;
		for(i=0;i<max_rows ;i++,j++) {
			if(j == sel_index) {
				wattron(sbox,A_REVERSE);
			}
			else {
				wattroff(sbox,A_REVERSE);
			}

			mvwprintw(sbox,i+1,1, "                           ");
			mvwprintw(sbox,i+1,1, " %s", serv[j].name);
		}

		wattroff(sbox,A_REVERSE);
		wrefresh(sbox);
	}

	if(key == 'q') 
		sel_index = -1;

	keypad(sbox, FALSE);
	nocbreak();
	echo();
	clear();
	delwin(sbox);
	wrefresh(stdscr);
	return(sel_index);

}


/* Player list box for kicking/banning
 */
int vcon_listbox(void)
{

	int i =0;
	int j;
	int key = 0;
	int max_rows = 16;
	int max_item = 0;
	int top_view_row = 0;
	int sel_index = 0;
	WINDOW *lbox;

	
	lbox = newwin(max_rows +2,30,4,15);
	box(lbox,'|','-');
	keypad(lbox,TRUE);
	cbreak();
	noecho();

	if(strstr(serv[cur_serv].game,"hlife")) {
		for(i=0;i<MAX_PLAYERS;i++) {
			if(csp[i].set)
				max_item++;	
		}
	}
	else if (strstr(serv[cur_serv].game,"source")) {
		for(i=0;i<MAX_SOURCE_PLAYERS;i++) {
			if(sourcep[i].set)
				max_item++;	
		}
	}
	else if (strstr(serv[cur_serv].game,"moh")) {
		for(i=0;i<MAX_BFPLAYERS;i++) {
			if(bfp[i].set)
				max_item++;	
		}
	}
	else if (strstr(serv[cur_serv].game,"quake3") || (strstr(serv[cur_serv].game,"cod"))) {

		for(i=0;i<MAX_Q3PLAYERS;i++) {
			if(q3p[i].set)
				max_item++;	
		}
	}
	
	
	max_item--;
	
	// only draw the up to the max_rows
	for(i=0;i<(max_rows );i++) {
		if(i == sel_index) {
			wattron(lbox,A_REVERSE);
		}
		else {
			wattroff(lbox,A_REVERSE);
		}

		if(strstr(serv[cur_serv].game,"hlife")) {
			mvwprintw(lbox,i+1,1, " %.*s",28, csp[i].name);
		}
		else if (strstr(serv[cur_serv].game,"source")) {
			mvwprintw(lbox,i+1,1, " %.*s", 28, sourcep[i].name);
		}
		else if (strstr(serv[cur_serv].game,"moh")) {
			mvwprintw(lbox,i+1,1, " %.*s", 28, bfp[i].name);
		}
		else if (strstr(serv[cur_serv].game,"quake3")) {
			mvwprintw(lbox,i+1,1, " %.*s", 28, q3p[i].name);
		}
	
	
	}

	wattroff(lbox,A_REVERSE);
	wrefresh(lbox);

	key = 0;
	while(key != 'q' && key != KEY_ENTER && key != '\n') {

		key = getch();
		if(key == 65) { //UP
			if(sel_index == top_view_row) {
				if(sel_index == 0) {
					sel_index = 0;
				} 
				else {
					top_view_row--;
					sel_index--;
				}
			}	
			else
				sel_index--; 
		}
		if(key == 66) { //DOWN
			if(sel_index == (top_view_row + max_rows -1 )) {
				if(sel_index == max_item)
					sel_index = sel_index;
				else {
					top_view_row++;
					sel_index++;
				}
			}	
			else {
				if(sel_index != max_item) 
					sel_index++;
			}
		}


		j = top_view_row;;
		for(i=0;i<max_rows ;i++,j++) {
			if(j == sel_index) {
				wattron(lbox,A_REVERSE);
			}
			else {
				wattroff(lbox,A_REVERSE);
			}

			mvwprintw(lbox,i+1,1, "                           ");
			if(strstr(serv[cur_serv].game,"hlife")) {
				mvwprintw(lbox,i+1,1, " %s", csp[j].name);
			}
			else if (strstr(serv[cur_serv].game,"source")) {
				mvwprintw(lbox,i+1,1, " %s", sourcep[j].name);
			}
			else if (strstr(serv[cur_serv].game,"moh")) {
				mvwprintw(lbox,i+1,1, " %s", bfp[j].name);
			}
			else if (strstr(serv[cur_serv].game,"quake3")) {
				mvwprintw(lbox,i+1,1, " %s", q3p[j].name);
			}
		}

		wattroff(lbox,A_REVERSE);
		wrefresh(lbox);
	}

	if(key == 'q') 
		sel_index = -1;

	keypad(lbox, FALSE);
	nocbreak();
	echo();
	clear();
	delwin(lbox);
	wrefresh(stdscr);
	return(sel_index);

}


void get_return()
{
	int ch;
	mvprintw(RETURN_LINE, 1, "%s", " Press Return ");
	refresh();
	while((ch = getch()) != '\n' && ch != EOF) ;
}





/* 
 * Process datagram
 */

char * p_dgram(char *dgram) 
{
	int i;
	int x;
	static char buf[MAX_ENTRY];
	char tbuf[250];

	memset(buf,'\0',sizeof(buf));
	memset(tbuf,'\0',sizeof(tbuf));
	strlcpy(buf,dgram,sizeof(buf));

	for(i=0,x=0;i<strlen(buf);i++,x++) {
		if(buf[i] == '\n') {
			proc_line(tbuf);
			memset(tbuf,'\0',sizeof(tbuf));
			x=-1;
		}
		else
			tbuf[x] = buf[i];
	}

	return buf;
}


void proc_line(char *line)
{
	int i;
	int curplay;
	int count;
	char *r;
	char *sp;
	char *tp;
	char *tmpp;
	char tmpbuf[100];

	curplay=0;
	memset(tmpbuf, '\0', sizeof(tmpbuf));
	switch(line[0]) {
		case 	'#':
			 /* Proc Player */

			if(strchr(line,'"') == NULL) 
				break;
			/* find the next available slot */
			for (i=0;i<MAX_PLAYERS;i++) {
				if(!csp[i].set) {
					curplay = i;
					csp[i].set = true;
					break;	
				}
			}

			/* Populate Player objects */
			
			/* name */
			sp = strchr(line,'"');
			sp++;

			i=0;
			while(*sp != '"') {
				tmpbuf[i++] = *sp;
				sp++;
			}
		
			strlcpy(csp[curplay].name, tmpbuf,sizeof(csp[curplay].name));
			
	
			/* Ignore this field .. */	
			memset(tmpbuf,'\0',sizeof(tmpbuf));	
			tp = trim_b_space(sp+1, tmpbuf);

			
			/* WONID */
			memset(tmpbuf,'\0',sizeof(tmpbuf));
			tp = trim_b_space(tp, tmpbuf);
	
			strlcpy(csp[curplay].wonid,tmpbuf,sizeof(csp[curplay].wonid));

			for (i= 0 ; i <= TOTAL_ADMINS ; i++) {
				if(strcmp(tmpbuf,adminWONIDS[i]) == 0) {
					snprintf(csp[curplay].wonid, sizeof(csp[curplay].wonid), "%s%s", tmpbuf,"*") ;
				}
			}

			for (i= 0 ; i <= TOTAL_FLAG ; i++) {
				if(strcmp(tmpbuf,flagWONIDS[i]) == 0) {
					snprintf(csp[curplay].wonid,sizeof(csp[curplay].wonid), "%s%s", tmpbuf,"!") ;
				}
			}

			/* Frags */

			memset(tmpbuf,'\0',sizeof(tmpbuf));
			tp = trim_b_space(tp, tmpbuf);
			strlcpy(csp[curplay].frags,tmpbuf,sizeof(csp[curplay].frags));

			/* TIME */

			memset(tmpbuf,'\0',sizeof(tmpbuf));
			tp = trim_b_space(tp, tmpbuf);

			/* Put an h after the time, if its in hours */
			count = 0;	
			for(i=0;i<strlen(tmpbuf);i++) {
				if(tmpbuf[i] == ':')
					count++;
			}
			if(count > 1) {
				tmpp = strrchr(tmpbuf, ':');
				memset(tmpp,'\0',1);
				strlcat(tmpbuf,"h", sizeof(tmpbuf));
			}

			strlcpy(csp[curplay].time,tmpbuf,sizeof(csp[curplay].time));

			/* PING */

			memset(tmpbuf,'\0',sizeof(tmpbuf));
			tp = trim_b_space(tp, tmpbuf);

			strlcpy(csp[curplay].ping,tmpbuf,sizeof(csp[curplay].ping));

			/* IP */

			/* ignore next field */
			memset(tmpbuf,'\0',sizeof(tmpbuf));
			tp = trim_b_space(tp, tmpbuf);

			memset(tmpbuf,'\0',sizeof(tmpbuf));
			tp = trim_b_space(tp, tmpbuf);
			for(i=0;i<strlen(tmpbuf);i++) {
				if(tmpbuf[i] == ':')
					tmpbuf[i] = '\0';
			}

			strlcpy(csp[curplay].ip,tmpbuf,sizeof(csp[curplay].ip));

			for (i= 0 ; i <= TOTAL_IP ; i++) {
				if(strcmp(tmpbuf,flagIP[i]) == 0) {
					snprintf(csp[curplay].ip,sizeof(csp[curplay].ip), "%s%s",tmpbuf, "*") ;
				}
			}

			break;
		case 	' ':
			break;
		default:
			if(strstr(line, "hostname")) {
				r = strchr(line,':');
				strlcpy(csrv.hostname, r+1,sizeof(csrv.hostname));
			}
			else if(strstr(line, "version")) {
				r = strchr(line,':');
				strlcpy(csrv.version, r+1,sizeof(csrv.version));
			}
			else if(strstr(line, "tcp")) {
				r = strchr(line,':');
				strlcpy(csrv.ip, r+1,sizeof(csrv.ip));
			}
			else if(strstr(line, "map")) {
				r = strchr(line,':');
				strlcpy(csrv.map, r+1,sizeof(csrv.map));
				r = strchr(csrv.map,':');
				*(r-3) = '\0';
			}
			else if(strstr(line, "players")) {
				r = strchr(line,':');
				strlcpy(csrv.players, r+2,sizeof(csrv.players));
			}
			break;
	}
}


// If punkbuster, get relevant info
void proc_q3_punk(char *data)
{

}


/*
 * Trim beginning spaces 
 * and populate tmpb with first field 
 * returns pointer 
 */


char * trim_b_space(char *s,char *tmpb)
 {
	int i; 
	

	 i = 0;
         while(isspace(s[i]) && (s[i] != '\0')) {
		 i++;
         }
	 s = s+i;

	i = 0;
	while(!isspace(s[i]) && (s[i] != '\0')) {
		 tmpb[i] = s[i];
		 i++;
	}

	return s = s+i;
}



/* 
 * Clear Server and Player Objects
 */
void clear_sap(void)
{
	int i;

	memset(csrv.hostname, '\0', sizeof(csrv.hostname));
	memset(csrv.version, '\0', sizeof(csrv.version));
	memset(csrv.ip, '\0', sizeof(csrv.ip));
	memset(csrv.map, '\0', sizeof(csrv.map));
	memset(csrv.players, '\0', sizeof(csrv.players));

	for(i=0;i<MAX_PLAYERS;i++) {	
		csp[i].set = false;
		memset(csp[i].name, '\0', sizeof(csp[i].name));
		memset(csp[i].userid, '\0', sizeof(csp[i].userid));
		memset(csp[i].wonid, '\0', sizeof(csp[i].wonid));
		memset(csp[i].frags, '\0', sizeof(csp[i].frags));
		memset(csp[i].time, '\0', sizeof(csp[i].time));
		memset(csp[i].ping, '\0', sizeof(csp[i].ping));
		memset(csp[i].loss, '\0', sizeof(csp[i].loss));
		memset(csp[i].ip, '\0', sizeof(csp[i].ip));
	}

	memset(sourcesi.hostname, '\0', sizeof(sourcesi.hostname));
	memset(sourcesi.version, '\0', sizeof(sourcesi.version));
	memset(sourcesi.ip, '\0', sizeof(sourcesi.ip));
	memset(sourcesi.map, '\0', sizeof(sourcesi.map));
	memset(sourcesi.players, '\0', sizeof(sourcesi.players));
	memset(sourcesi.max_players, '\0', sizeof(sourcesi.max_players));

	for(i=0;i<MAX_SOURCE_PLAYERS;i++) {	
		sourcep[i].set = false;
		memset(sourcep[i].name, '\0', sizeof(sourcep[i].name));
		memset(sourcep[i].userid, '\0', sizeof(sourcep[i].userid));
		memset(sourcep[i].wonid, '\0', sizeof(sourcep[i].wonid));
		memset(sourcep[i].frags, '\0', sizeof(sourcep[i].frags));
		memset(sourcep[i].ping, '\0', sizeof(sourcep[i].ping));
		memset(sourcep[i].ip, '\0', sizeof(sourcep[i].ip));
	}

	bfsi.set = false;
	memset(bfsi.language,'\0',sizeof(bfsi.language));
	memset(bfsi.gamever,'\0',sizeof(bfsi.gamever));
	memset(bfsi.gamename,'\0',sizeof(bfsi.gamename));
	bfsi.reservedslots = 0;
	bfsi.roundTime = 0;
	memset(bfsi.mapId,'\0',sizeof(bfsi.mapId));
	memset(bfsi.version,'\0',sizeof(bfsi.version));
	bfsi.dedicated = false;
	bfsi.password = false;
	memset(bfsi.gamemode,'\0',sizeof(bfsi.gamemode));
	memset(bfsi.maxplayers,'\0',sizeof(bfsi.maxplayers));
	memset(bfsi.numplayers,'\0',sizeof(bfsi.numplayers));
	memset(bfsi.gametype,'\0',sizeof(bfsi.gametype));
	memset(bfsi.mapname,'\0',sizeof(bfsi.mapname));
	memset(bfsi.hostport,'\0',sizeof(bfsi.hostport));
	memset(bfsi.hostname,'\0',sizeof(bfsi.hostname));
	bfsi.CPU =0;
	memset(bfsi.Hit_Indicator,'\0',sizeof(bfsi.Hit_Indicator));
	memset(bfsi.TK_Mode,'\0',sizeof(bfsi.TK_Mode));
	memset(bfsi.SoldierFF,'\0',sizeof(bfsi.SoldierFF));
	memset(bfsi.VehicleFF,'\0',sizeof(bfsi.VehicleFF));

	memset(ut2si.hostname,'\0',sizeof(ut2si.hostname));
	memset(ut2si.version,'\0',sizeof(ut2si.version));
	memset(ut2si.port,'\0',sizeof(ut2si.port));
	memset(ut2si.map,'\0',sizeof(ut2si.map));
	memset(ut2si.game_type,'\0',sizeof(ut2si.game_type));
	memset(ut2si.game_mode,'\0',sizeof(ut2si.game_mode));
	memset(ut2si.players,'\0',sizeof(ut2si.players));
	memset(ut2si.max_players,'\0',sizeof(ut2si.max_players));
	memset(ut2si.num_players,'\0',sizeof(ut2si.num_players));
	ut2si.password = false;



	for (i=0;i<MAX_BFPLAYERS;i++){
		bfp[i].set = false;
		bfp[i].num = -1; 
		memset(bfp[i].name,'\0',sizeof(bfp[i].name));
		memset(bfp[i].frags,'\0',sizeof(bfp[i].frags));
		memset(bfp[i].deaths,'\0',sizeof(bfp[i].deaths));
		memset(bfp[i].score,'\0',sizeof(bfp[i].score));
		memset(bfp[i].ping,'\0',sizeof(bfp[i].ping));
		memset(bfp[i].team,'\0',sizeof(bfp[i].team));
	}

	for (i=0;i<MAX_UTPLAYERS;i++){
		utp[i].set = false;
		utp[i].num = -1; 
		memset(utp[i].name,'\0',sizeof(utp[i].name));
		memset(utp[i].frags,'\0',sizeof(utp[i].frags));
		memset(utp[i].deaths,'\0',sizeof(utp[i].deaths));
		memset(utp[i].score,'\0',sizeof(utp[i].score));
		memset(utp[i].ping,'\0',sizeof(utp[i].ping));
		memset(utp[i].team,'\0',sizeof(utp[i].team));
	}

	for (i=0;i<MAX_Q3PLAYERS;i++){
		q3p[i].set = false;
		q3p[i].num = -1; 
		memset(q3p[i].name,'\0',sizeof(q3p[i].name));
		memset(q3p[i].frags,'\0',sizeof(q3p[i].frags));
		memset(q3p[i].score,'\0',sizeof(q3p[i].score));
		memset(q3p[i].ping,'\0',sizeof(q3p[i].ping));
	}
}


void p_version(void) 
{
	printf("vrcon - %s\t Copyright (C) 2003 Sam Vaughan\n\n",VRCON_VERSION);
	printf("Written by Sam \"Jack Bauer\" Vaughan\n\n");

}

void p_usage(void) 
{
	printf("Usage: vrcon [-h] [-v] [-C config file] [-S] [-s n] [-l] [-m] [-r command] \n\n");
	printf("vrcon is a curses based rcon utility.\n");
	printf("With no options vrcon is started in interactive mode.\n");
	printf("The -s switch must come before -l, -m, or -r\n\n");
	printf("options\n");
	printf("  -l, list players and exit.\n");
	printf("  -m, list maps and exit.\n");
	printf("  -h, list help, this text.\n");
	printf("  -r <command>   Runs the rcon command and returns results to the stdout.\n");
	printf("  -C config file>  Use config file instead of default ~/.vrcon.\n");
	printf("  -s n, Overide the default server. n is a numeric value. \n");
	printf("        1 would be the first server listed in your config file\n");
	printf("        2 would be the next one. etc etc.                     \n");
	printf("  -S,  Show severs from config file (and numbers for use with -s). \n");
	printf("  -v, show version.\n");
	printf("\n");

}

int main(int argc, char *argv[])
{

	int z;
	int i;
	int mx;
	int my;
	int choice;
	int mode = gui;
	int player; 
	int tmps;
	int servnum;
	int srun;
	int rcon_results = -1;
	size_t slen;
	char *info = NULL;
	char cmd[256];
	char r_cmd[256];
	char *m = NULL;
	char *g = NULL;



	memset(cmd, '\0', sizeof(cmd));

	for (i=0;i<MAX_SERV;i++){
		serv[i].set = false;
		memset(serv[i].name,'\0',sizeof(serv[i].name));
		memset(serv[i].cs_server_addr,'\0',sizeof(serv[i].cs_server_addr));
		serv[i].cs_server_port = 0;
		serv[i].rcon_port = 0;
		memset(serv[i].rcon_uname,'\0',sizeof(serv[i].rcon_uname));
		memset(serv[i].rcon_password,'\0',sizeof(serv[i].rcon_password));
		memset(serv[i].game,'\0',sizeof(serv[i].game));
	}

	cur_serv = 0;
	srun = 0; 

	/*
	 * read in config file
	 * and set serv struct
	 */

	
	memset(config_path,'\0', sizeof(config_path));
// One way of making sure we can overide the default config ....
	for (i=0; i<argc; i++) {
		if(strcmp(argv[i], "-C") == 0) {
			snprintf(config_path, sizeof(config_path),"%s",argv[i+1]);
			//printf("%d  %s  [%s]\n", argc, argv[i], argv[i+1]);
		}
	}

	load_config();

	c_menu = start_menu;	

	while ((z = getopt(argc, argv, "C:hlmvSs:r:")) != EOF) {
	        	switch((char)z) {
		        case 'l':
				mode=nogui;
				if(strcmp(serv[cur_serv].game,"hlife") == 0) {
					 info = send_hlife_rcon("users");	
					 if(info) 
						 printf("\n%s\n",info);
					 else 
						printf("\n Connect failed: Host seems to be down\n\n" );
				}
				else if(strcmp(serv[cur_serv].game,"moh") == 0) {
					 info = send_moh_rcon("status");	
					 if(info)
						 printf("\n%s\n",info);
					 else 
						printf("\n Connect failed: Host seems to be down\n\n" );

				}
				else if((strcmp(serv[cur_serv].game,"quake3") == 0) || (strcmp(serv[cur_serv].game,"cod") == 0)) {
					info = send_q3_rcon("status");
					 if(info)
						 printf("\n%s\n",info);
					 else 
						printf("\n Connect failed: Host seems to be down\n\n" );
				}
				else {
					 printf("\n Option -%c is only for Half-Life, Quake3 and MOH based servers\n",z);
				}
			break;
			case 'r': // Rcon command
				mode=nogui;
				memset(r_cmd,'\0',sizeof(r_cmd));
				slen = strlcpy(r_cmd,argv[optind -1], sizeof(r_cmd));

				if(strstr(serv[cur_serv].game,"hlife")) {
					info = send_hlife_rcon(r_cmd);
				}
				else if (strstr(serv[cur_serv].game,"source")) {
					info = send_source_rcon(r_cmd);
				}
				else if (strstr(serv[cur_serv].game,"moh")) {
					info = send_moh_rcon(r_cmd);
				}
				else if((strcmp(serv[cur_serv].game,"quake3") == 0) || (strcmp(serv[cur_serv].game,"cod") == 0)) {
					info = send_q3_rcon(r_cmd);
				}
				else {
					info = NULL;
				}

				if(info) 
					 printf("\n%s\n",info);
				else 
					printf("\n Connect failed: Host seems to be down\n\n" );
			break;
			case 'S':  /* Show Servers and servers number from your config file  */
				 mode=nogui;
				 printf("\n");
				 for(i=0; i<MAX_SERV;i++) {
					 if(serv[i].set)
						 printf(" %d. %s  [%s]\n",i+1, serv[i].name, serv[i].game);
				 }
				 printf("\n");
				 exit(1);

			break;
			case 's':  /* select Server from config
				    * Overiding the default one
				   */ 
			
				  servnum = atoi(argv[optind -1]);			
				  servnum--;
				  if( (servnum < 0) || (servnum > MAX_SERV)) {
					printf("\n Not a valid server number, try again!\n\n");
					exit(1);
				  }
				  
				  if(serv[servnum].set) {
					cur_serv = servnum ;
					srun = 1;

					if(strstr(serv[cur_serv].game,"hlife")) {
						c_menu = main_menu;	
					}
					else if(strstr(serv[cur_serv].game,"bf1942")) {
						c_menu = bf_menu;	
					}
					else if(strstr(serv[cur_serv].game,"moh")) {
						c_menu = moh_menu;	
					}
					else if((strcmp(serv[cur_serv].game,"quake3") == 0) || (strcmp(serv[cur_serv].game,"cod") == 0)) {
						c_menu = q3_menu;	
					}
					else {
						c_menu = start_menu;	
					}
				  }
				  else {
					printf("\n Not a valid server number, try again!\n\n");
					exit(1);
				  }

			break;

		        case 'm':
				 mode=nogui;
				if(strstr(serv[cur_serv].game,"hlife")) {
					 info = send_hlife_rcon("maps *");	
				}
				else if (strstr(serv[cur_serv].game,"moh")) {
					info = send_moh_rcon("sv_maplist");
				}
				else if((strcmp(serv[cur_serv].game,"quake3") == 0) || (strcmp(serv[cur_serv].game,"cod") == 0)) {
					info = send_q3_rcon("dir maps bsp");
				}

				else {
					info = NULL;
				}

				 if(info) 
					 printf("\n%s\n",info);
				 else 
					printf("\n Connect failed: Host seems to be down\n\n" );
			break;
			case 'C':
			break;
		        case 'h':
				 p_usage();
				 exit(1);
			break;
			case 'v':
				 p_version();
				 exit(1);
			break;
		        case '?':
				 p_usage();
				 exit(1);
			break;	 
		}
	}



	// Lets process 
	
	if(mode == nogui) 
	        exit(0);


	initscr();
	do {
		if((c_menu != start_menu) && srun == 1) {
			list_status();
			srun = 0;
		}

		choice = getchoice(topgreet, c_menu);

		switch(choice) {

		case 	's':
				list_status();
			break;
		case 	'K':
				memset(cmd,'\0',sizeof(cmd));
				player = vcon_listbox();
				if(player == -1) 
					list_status();
				else {

					if (strstr(serv[cur_serv].game,"moh")) {
						snprintf(cmd, sizeof(cmd), "clientkick %d", bfp[player].num);
						send_moh_rcon(cmd);
					}
					else if((strcmp(serv[cur_serv].game,"quake3") == 0) || (strcmp(serv[cur_serv].game,"cod") == 0)) {
						snprintf(cmd, sizeof(cmd), "kick \"%s\"", q3p[player].name);
						send_q3_rcon(cmd);
					}
					//mvprintw(8,20, "%s", "Select Refresh" );
					list_status();
					mvprintw(24,5, "Player was Kicked");
					wrefresh(stdscr);

				}



			break;
		case 	'j':
				memset(cmd,'\0',sizeof(cmd));
				player = vcon_listbox();
				if(player == -1) 
					list_status();
				else {

					
					if(strcmp(serv[cur_serv].game,"hlife") == 0) {
						snprintf(cmd, sizeof(cmd), "kick \"%s\"", csp[player].name);
					}
					else if(strcmp(serv[cur_serv].game,"source") == 0) {
						snprintf(cmd, sizeof(cmd), "kick \"%s\"", sourcep[player].name);
					}
					s_rcon_command(cmd);

					mvprintw(24,5, "Player was Kicked");
				}



			break;
		case 	'k':
				memset(cmd,'\0',sizeof(cmd));
				player = vcon_listbox();
				if(player == -1) 
					list_status();
				else {


					
					if(strcmp(serv[cur_serv].game,"hlife") == 0) {
						snprintf(cmd, sizeof(cmd), "banid 1 %s kick", csp[player].wonid);
					}
					else if(strcmp(serv[cur_serv].game,"source") == 0) {
						snprintf(cmd, sizeof(cmd), "banid 1 %s kick", sourcep[player].wonid);
					}

					rcon_results = s_rcon_command(cmd);
					if(rcon_results == 0) {
						mvprintw(2,20, "%s", "Player Kicked for 1 Min! " );
						mvprintw(3,20, "%s", "--------------------------" );
						mvprintw(8,20, "%s", "Select Refresh" );
					}
					else {
						mvprintw(2,20, "%s", "Rcon Error! " );
						mvprintw(3,20, "%s", "--------------------------" );
						mvprintw(8,20, "%s", "Select Refresh" );
					}
				}



			break;
		case 	'l':
				memset(cmd,'\0',sizeof(cmd));
				player = vcon_listbox();
				if(player == -1) 
					list_status();
				else {

					if(strcmp(serv[cur_serv].game,"hlife") == 0) {
						snprintf(cmd, sizeof(cmd), "banid 30 %s kick", csp[player].wonid);
					}
					else if(strcmp(serv[cur_serv].game,"source") == 0) {
						snprintf(cmd, sizeof(cmd), "banid 30 %s kick", sourcep[player].wonid);
					}

					rcon_results = s_rcon_command(cmd);
					if(rcon_results == 0) {
						mvprintw(2,20, "%s", "Player Kicked for 30 Min! " );
						mvprintw(3,20, "%s", "--------------------------" );
						mvprintw(8,20, "%s", "Select Refresh" );
					}
					else {
						mvprintw(2,20, "%s", "Rcon Error! " );
						mvprintw(3,20, "%s", "--------------------------" );
						mvprintw(8,20, "%s", "Select Refresh" );
					}
				}



			break;



		case 	'b':
				memset(cmd,'\0',sizeof(cmd));
				player = vcon_listbox();
				if(player == -1) 
					list_status();
				else {

					if(strcmp(serv[cur_serv].game,"hlife") == 0) {
						snprintf(cmd, sizeof(cmd), "banid 0 %s kick", csp[player].wonid);
					}
					else if(strcmp(serv[cur_serv].game,"source") == 0) {
						snprintf(cmd, sizeof(cmd), "banid 0 %s kick", sourcep[player].wonid);
					}

					rcon_results = s_rcon_command(cmd);
					if(rcon_results == 0) {

						// Need to do another command .. writeid so the ban is really perm
						s_rcon_command("writeid");
						mvprintw(5,20, "%s", "Player Permanately Banned!" );
						mvprintw(6,20, "%s", "--------------------------" );
						mvprintw(8,20, "%s", "Select Refresh" );
					}
					else {
						mvprintw(2,20, "%s", "Rcon Error! " );
						mvprintw(3,20, "%s", "--------------------------" );
						mvprintw(8,20, "%s", "Select Refresh" );
					}
				}

			break;

		case	'M':
		
			if(get_confirm("Restart the Map? " )) {
				send_q3_rcon("map_restart");
				clear();	
				wrefresh(stdscr);
				list_status();
			}
			break;
		case	'm':
				m = NULL; 
				memset(cmd,'\0',sizeof(cmd));
				if(strcmp(serv[cur_serv].game,"cod") == 0) {
					g = cod_gametype_box();	
					if(g)
						m = cod_mbox(g);	
				}
				else {
					m = vcon_mbox();	
				}

				if(m == NULL) 
					list_status();
				else {
					getmaxyx(stdscr,my,mx);

					if(strstr(serv[cur_serv].game,"hlife")) {
						snprintf(cmd,sizeof(cmd), "changelevel %s", m);
						s_rcon_command(cmd);
						mvprintw(my -2, 1, "Please wait while server loads new map.. " );
						wrefresh(stdscr);
					}
					else if (strstr(serv[cur_serv].game,"source")) {
						snprintf(cmd,sizeof(cmd), "changelevel %s", m);
						s_rcon_command(cmd);
						mvprintw(my -2, 1, "Please wait while server loads new map.. " );
						wrefresh(stdscr);
					}
					else if (strstr(serv[cur_serv].game,"moh")) {
						snprintf(cmd,sizeof(cmd), "map %s", m);
						send_moh_rcon(cmd);
						mvprintw(my -2, 1, "Please wait while server loads new map.. " );
						wrefresh(stdscr);
					}
					else if(strcmp(serv[cur_serv].game,"quake3") == 0) {
						snprintf(cmd,sizeof(cmd), "map %s", m);
						send_q3_rcon(cmd);
						mvprintw(my -2, 1, "Please wait while server loads new map.. " );
						wrefresh(stdscr);
					}
					else if(strcmp(serv[cur_serv].game,"cod") == 0) {
						mvprintw(my -2, 1, "Please wait while server loads new map.. " );
						wrefresh(stdscr);
						snprintf(cmd,sizeof(cmd), "g_gametype %s",g);
						send_q3_rcon(cmd);
						sleep(1);
						mvprintw(my -2, 1, "Please wait while server loads new map.... " );
						wrefresh(stdscr);
						memset(cmd,'\0',sizeof(cmd));
						snprintf(cmd,sizeof(cmd), "map %s", m);
						send_q3_rcon(cmd);
						sleep(1);
						mvprintw(my -2, 1, "Please wait while server loads new map..... " );
						wrefresh(stdscr);
						send_q3_rcon("map_restart");
					}


					sleep(2);
					info = NULL;
					while (info == NULL) {
						mvprintw(my -2, 1, "Please wait while server loads new map....... " );
						wrefresh(stdscr);

						if(strcmp(serv[cur_serv].game,"hlife") == 0) {	
							info = send_hlife_rcon("status");	
						}
						else if(strcmp(serv[cur_serv].game,"source") == 0) {
							info = get_source_status(); 
						}
						else if(strcmp(serv[cur_serv].game,"moh") == 0) {
							info = get_status("\\status\\"); 
						}
						else if((strcmp(serv[cur_serv].game,"quake3") == 0) || (strcmp(serv[cur_serv].game,"cod") == 0)) {
							info = get_status("\xff\xff\xff\xffgetstatus"); 
						}
					}

					clear();	
					wrefresh(stdscr);
					list_status();


				}
			break;

		case 	'c':
				s_rcon_command("cm_clexec * screenshot");
			break;
		case	't': 
				CmSayCommand(0);
			break;
		case	'T': 
				CmSayCommand(1);
			break;
		case	'p': 
				s_rcon_command("pb_sv_plist");
			break;
		case	'P': 
				s_rcon_command("pb_sv_getss");
			break;
		case 	'i':
				tmps  = vcon_sbox();
				if(tmps != -1) {
					cur_serv = tmps;
				}
				list_status();
				selected_row = 0;
			break;
		case 	'I':
				//tmps  = edit_server_listbox();
				//edit_server_form(tmps);

			break;
		case 	'E':
				/* ESC should bring you back to main */
				c_menu = start_menu;
				selected_row = 0;
				clear_all_screen();
				wrefresh(stdscr);
			break;
		case 	'q':
		/*	
			if(!get_confirm()) {
				choice = '.';
				mvprintw(Q_LINE, 1, "                    ");
				refresh();
			}
		*/
			break;
		case 	'a':
			rcon_command();
			break;
		}	

	}while (choice != 'q');

clear();
refresh();
endwin();
exit(EXIT_SUCCESS);

}

